<?php

namespace App\Exports;

use App\Models\Product;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ProductExport implements FromCollection,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return collect(DB::select('SELECT p.*, s.price, s.stock FROM products AS p INNER JOIN product_stock AS s ON p.id = s.product_id'));
    }

    public function headings(): array
    {
        // Get column names from products table
        $productColumns = Schema::getColumnListing((new Product)->getTable());

        // Manually add missing columns from product_stock
        return array_merge($productColumns, ['price', 'stock']);
    }
}
