<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Country;
use App\Models\Region;
use App\Models\Page;
use App\Models\Attribute;
use App\Models\Color;
use App\Models\Brand;
use App\Models\Product;
use App\Models\Menu;
use App\Models\MenuItem;
use App\Models\Order;
use Carbon\Carbon;
use App\Models\OrderProduct;
use App\Models\User;
use App\Models\Winner;
use App\Models\Area;
use App\Models\GalleryImage;
use App\Models\Testimonial;

use App\Models\GalleryVideo;
use App\Models\AboutStruc;
use App\Models\Announcement;
use App\Models\BlogCategory;
use App\Models\BlogItem;
use App\Models\HomeSlider;
use App\Models\IntroSlider;
use App\Models\OfferSlider;
use App\Models\ShippingMethod;
use App\Models\PaymentMethod;
use App\Models\Coupon;
use App\Models\Branche;

use App\Models\InstallmentPartner;
use App\Models\ProductStock;
use App\Models\Service;
use App\Models\Slider;

use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    /////////// function return admin index view //////////


   public function admin(){
        //------------------------------
        /////     Orders Report     /////

        $data['reports']['totalOrders'] = Order::count();
        $data['reports']['currentMonthOrders'] = Order::whereYear('created_at', Carbon::now()->year)->whereMonth('created_at', Carbon::now()->month)->count();
        $data['reports']['pendingOrders'] = Order::whereHas('status',function($q){
            $q->whereStatus('pending');
        })->count();
        $data['reports']['pendingOrdersCost'] = Order::whereHas('status',function($q){
            $q->whereStatus('pending');
        })->sum('total_price');
        $data['reports']['totalOrdersCost'] = Order::sum('total_price');
        $data['reports']['ordersQuantity'] = OrderProduct::sum('quantity');
        $data['reports']['currentMonthOrdersCost'] = Order::whereYear('created_at', Carbon::now()->year)->whereMonth('created_at', Carbon::now()->month)->sum('total_price');
        $data['reports']['lastMonthOrdersCost'] = Order::whereYear('created_at', Carbon::now()->year)->where('created_at', '>=', Carbon::now()->subMonth()->month)->sum('total_price');
        $data['orders'] = Order::orderBy('id','DESC')->take(10)->get();


        //--------------------------------//
        /////     Products Report     /////

        $products = Product::query();
        $data['reports']['productCount'] = $products->count() ;
        $data['reports']['availableProductNumber'] = $products->active()->count();
        $data['reports']['productHasStock'] = $products->hasStock()->count();
        $data['reports']['productsPrice'] = ProductStock::sum('price');

        //--------------------------------//
        /////     uesrs Report     /////

        $data['reports']['usersCount'] = User::count();
        // $currentMonthUsers = User::whereYear('created_at', Carbon::now()->year)->whereMonth('created_at', Carbon::now()->month)->count();

        //--------------------------------//
        /////     categories Report     /////

        $data['reports']['categoriesNumber'] = Category::count();

        /////     brands Report     /////

        $data['reports']['brandsNumber'] = Brand::count();

        return view('admin.index',$data);
    }

    ///// function set session lang of the app////
    public function setlang($lang){
        $langs = ['en', 'ar'];
        if (in_array($lang, $langs)) {
            session(['lang' => $lang]);
            return redirect()->back();
        }
    }


    ///// function publish and unpublish status////
    public function updatestatus($name, $ids)
    {
        $ids = explode(',', $ids);

        foreach ($ids as $x) {
            $update = null;

            switch ($name) {
                case 'categories':
                    $update = Category::find($x);
                    break;
                case 'services':
                    $update = Service::find($x);
                    break;

                case 'countries':
                    $update = Country::find($x);
                    break;

                case 'announcements':
                    $update = Announcement::find($x); // Corrected the model to match the name
                    break;

                case 'regions':
                    $update = Region::find($x);
                    break;

                case 'areas':
                    $update = Area::find($x);
                    break;

                case 'attributes':
                    $update = Attribute::find($x);
                    break;
                case 'testimonials':
                    $update = Testimonial::find($x);
                    break;

                case 'brands':
                    $update = Brand::find($x);
                    break;

                case 'pages':
                    $update = Page::find($x);
                    break;

                case 'products':
                    $update = Product::find($x);
                    break;

                case 'menus':
                    $update = Menu::find($x);
                    break;

                case 'aboutStrucs':
                    $update = AboutStruc::find($x);
                    break;

                case 'sliders':
                    $update = Slider::find($x);
                    break;

                case 'coupons':
                    $update = Coupon::find($x);
                    break;
            }

            // Skip processing if no record is found
            if (!$update) {
                continue;
            }

            // Toggle the status
            $update->status = $update->status == 0 ? 1 : 0;
            $update->save();
        }
        return response()->json(['message' => 'Process completed successfully.']);
    }



    public function switchTheme(){

        $user =User::find(Auth::user()->id);
        if ($user ->theme == 'default') {
            $user ->theme = 'dark';
            $user ->save();
        }else {
            $user->theme = 'default';
            $user->save();
        }

        return back();
    }
}
