<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AreaRequest;
use App\Models\Region;
use App\Models\Area;
use Exception;

class AreaController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:areas']);
    }

    public function index()
    {
        //
        $areas = Area::orderBy('id','DESC')->with(['region'])->get();
        return view('admin.areas.areas',compact('areas'));
    }


    public function create()
    {
        //
        $regions = Region::where('status',1)->get();
        return view('admin.areas.addArea',compact('regions'));
    }


    public function store(AreaRequest $request)
    {
        $data = $request->validated() ;
        if(Area::create($data)){
            return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
        }
        return redirect()->back()->withErrors(trans('home.an home.an error has occurred. Please contact the developer to resolve the issue'));

    }




    public function edit($id)
    {
        $area = Area::find($id);

        if($area){
            $regions = Region::where('status',1)->get();
            return view('admin.areas.editArea',compact('regions','area'));
        }else{
            abort('404');
        }
    }


    public function update(AreaRequest $request, $id)
    {
        $area = Area::find($id);
        $data = $request->validated() ;
        if($area->update($data)){
            return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
        }
        return redirect()->back()->withErrors(trans('home.an home.an error has occurred. Please contact the developer to resolve the issue'));
    }

    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:areas,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Area::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($area = Area::find($id)){
                $area->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
