<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\Models\Delivery;
use Exception;
use File;
use Image;

class DeliveryController extends Controller
{

    public function __construct(){
        $this->middleware(['permission:deliveries']);
    }

    public function index()
    {
        //
        $deliveries = Delivery::all();
        return view('admin.deliveries.deliveries',compact('deliveries'));
    }


    public function create()
    {
        return view('admin.deliveries.addDelivery');
    }


    public function store(Request $request)
    {
        //
        $add = new Delivery();
        $add->name = $request->name;
        $add->phone = $request->phone;
        $add->status = $request->status;
        $add->save();

        return redirect()->route('deliveries.index')->with('success',trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {
        //
        $delivery = Delivery::find($id);
        if($delivery){
            return view('admin.deliveries.editDelivery',compact('delivery'));
        }else{
            abort('404');
        }

    }


    public function update(Request $request, $id)
    {
        //
        $add = Delivery::find($id);
        $add->name = $request->name;
        $add->phone = $request->phone;
        $add->status = $request->status;
        $add->save();
        return redirect()->route('deliveries.index')->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:deliveries,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Delivery::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($delivery = Delivery::find($id)){
                $delivery->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
