<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\MenuRequest;
use App\Models\Menu;
use DB;
use Exception;

class MenuController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:menus');
    }

    public function index()
    {

        $data['menus'] = Menu::where('type','main')->get();
        return view('admin.menus.menus',$data);
    }


    public function create()
    {

        $data['menus'] = Menu::where('type','main')->get();
        return view('admin.menus.addMenu',$data);
    }


    public function store(MenuRequest $request)
    {

        Menu::create($request->validated());
        return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {

        if( $data['menu']= Menu::find($id)){
            $data['menus'] = Menu::where('type','main')->get();
            return view('admin.menus.editMenu',$data);
        }
        return abort(404);
    }


    public function update(MenuRequest $request,$id)
    {

        if( $menu = Menu::find($id)){
            $menu->update($request->validated());
            return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
        }

        return abort(404);
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:menus,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Menu::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($menu = Menu::find($id)){
                $menu->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
