<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Models\Attribute;
use App\Http\Requests\ProductRequest;
use App\Models\Color;
use App\Models\Brand;
use Picqer;
use App\Models\CategoryColor;
use App\Traits\ImagesTrait;
use App\Traits\Products\ProductAjaxTrait;
use App\Traits\Products\ProductAttributeTrait;
use App\Traits\Products\ProductDiscountTrait;
use App\Traits\Products\ProductImageTrait;
use App\Traits\Products\ProductStockTrait;
use Exception;
use App\Imports\ProductImport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use App\Exports\ProductExport;
use App\Helpers\Helper;

class ProductController extends Controller
{

    use ProductDiscountTrait, ImagesTrait, ProductAjaxTrait, ProductImageTrait ,ProductStockTrait ,ProductAttributeTrait;

    public function __construct(){

        $this->middleware(['permission:products']);
    }


    public function index(){
        $products = Product::orderBy('id','DESC')->get();
        return view('admin.products.products',compact('products'));
    }


    ////////// function generate barcode///////////
    public function generateBarcode(){

        if($_POST['barcode']){
            $label=$_POST['barcode'];
        }else{
            $label = mt_rand();
        }

        $barcode_generator = new Picqer\Barcode\BarcodeGeneratorPNG();

        $barcode=$barcode_generator->getBarcode($label,$barcode_generator::TYPE_CODE_128 );

        return response()->json([base64_encode($barcode),$label]);
    }

    public function create()
    {
        $data['categories'] = Category::where('status',1)->whereDoesntHave('children')->get();
        $data['brands'] = Brand::where('status',1)->get();
        $data['attributes'] = Attribute::where('status',1)->whereHas('values')->get();
        return view('admin.products.addProduct',$data);
    }

    public function store(ProductRequest $request)
    {
        $data = $request->validated();
        if ($request->hasFile("main_image")) {
            $saveImage = new SaveImageTo3Path(request()->file('main_image'),true);
            $fileName = $saveImage->saveImages('products');
            $data['main_image'] = $fileName ;
        }

        if ($request->hasFile("second_image")) {
            $saveImage = new SaveImageTo3Path(request()->file('second_image'),true);
            $fileName = $saveImage->saveImages('products');
            $data['second_image'] = $fileName ;
        }
        $data['vendor_id'] = auth()->user()->vendor_id ;
        $data['approved'] = auth()->user()->isAdmin() ;
        $product = Product::create($data) ;
        $product->stocks()->create($data) ;

        foreach ($data['attributes'] ??  [] as  $value) {
            $product->attributes()->create(['attribute_id' => $value]);

        }
        return redirect()->to("admin/products")->with('success',trans('home.your_produt_added_successfully_upload_images_and_complete_specifications'));
    }

    public function edit($id)
    {
        //
        $product = Product::find($id);

        if($product){
            $data['product'] = $product ;
            $data['categories'] = Category::where('status',1)->whereDoesntHave('children')->get();
            $data['brands'] = Brand::where('status',1)->get();
            $data['attributes'] = Attribute::where('status',1)->whereHas('values')->get();
            return view('admin.products.editProduct',$data);
        }else{
            return redirect()->back()->withErrors(__('home.product not found'));
        }

    }


    public function approved($id)
    {
        try {
            $product = Product::findOrFail($id);
            $product->update(['approved' => !$product->approved]);
            return redirect()->to('admin/products')->with('success',__('home.your_data_have_been_updated_successfully'));

        } catch (Exception $th) {
            return redirect()->back()->withErrors(__('home.Your data wasn\'t changed. Please contact the owner'));
        }


    }

    public function update(ProductRequest $request, $id){

        $product = Product::find($id);
        $data = $request->validated();
        if ($request->hasFile("main_image")) {
            $saveImage = new SaveImageTo3Path(request()->file('main_image'),true);
            $fileName = $saveImage->saveImages('products');
            $data['main_image'] = $fileName ;
        }

        if ($request->hasFile("second_image")) {
            $saveImage = new SaveImageTo3Path(request()->file('second_image'),true);
            $fileName = $saveImage->saveImages('products');
            $data['second_image'] = $fileName ;
        }

        $product->update( $data);

        $newAttribute = array_diff($data['attributes'] ?? [] , $product->attributes->pluck('attribute_id')->toArray()) ;
        $deletedAttribure = array_diff( $product->attributes->pluck('attribute_id')->toArray() ,$data['attributes'] ?? []) ;

        $product->update( $data);

        $product->attributes()->whereIn('attribute_id' ,$deletedAttribure )->delete();

        foreach ( $newAttribute ??  [] as $key => $value) {
            $product->attributes()->create(['attribute_id' => $value]);

        }

        foreach ($data['attributes'] ??  [] as $key => $value) {
            $product->attributes()->create(['attribute_id' => $value]);

        }

        return redirect()->back()->with('success',trans('home.product_data_updated_successfully'));
    }

    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:products,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Product::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($product = Product::find($id)){
                $product->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json(Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }


    public function export()
    {
        return Excel::download(new ProductExport, 'products.xlsx');
    }

    public function import(Request $request)
    {

        $request->validate([
            'excel' => 'required|mimes:xlsx,csv,xls'
        ]);
        Excel::import(new ProductImport, $request->file('excel'));

        return back()->with('success', 'Excel data imported successfully!');
    }


}
