<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\VendorRequest;
use App\Models\Area;
use App\Models\Country;
use App\Models\Region;
use App\Models\Vendor;
use Exception;
use Illuminate\Database\QueryException;

class VendorController extends Controller
{
    public function index()
    {
        $data['vendors'] =  Vendor::all() ;
        return view('admin.vendors.index' ,$data) ;
    }


    public function create()
    {
        $data['countries'] = Country::all();
        return view('admin.vendors.create',$data);
    }

    public function store(VendorRequest $request)
    {
        try{
            foreach ($request->file() as $key =>$file ) {
                if (in_array($key,['logo'])) {
                    $saveImage = new SaveImageTo3Path($file,true);
                    $fileName = $saveImage->saveImages(Vendor::IMAGE_FOLDER);
                    $data[$key] = $fileName;
                }

            }
            Vendor::create($request->validated());
            return redirect()->to('admin/vendors')->with('success' , __('home.your_item_added_successfully')) ;
        }catch(QueryException $qEx){
            return redirect()->back()->withErrors(__('home.YoYour data wasn\'t saved. Please try again or contact the owner')) ;
        }catch(\Throwable $e){
            return redirect()->back()->withErrors(__('home.Your data wasn\'t saved. Please contact the owner')) ;

        }
    }


    public function edit(Vendor $vendor)
    {
        $data['vendor'] =  $vendor ;
        $data['countries'] = Country::all();
        $data['regions'] = Region::where('country_id',$vendor->country_id)->get();
        $data['areas'] = Area::where('region_id',$vendor->region_id)->get();
        return view('admin.vendors.edit',$data) ;
    }

    public function update(VendorRequest $request, Vendor $vendor)
    {

       try{
            foreach ($request->file() as $key =>$file ) {
                if (in_array($key,['logo'])) {

                    $saveImage = new SaveImageTo3Path($file,true);
                    $fileName = $saveImage->saveImages(Vendor::IMAGE_FOLDER);
                    SaveImageTo3Path::deleteImage($vendor->{$key}, Vendor::IMAGE_FOLDER);
                    $data[$key] = $fileName;
                }

            }
            $vendor->update($request->validated());
            return redirect()->to('admin/vendors')->with('success' , __('home.your_item_added_successfully')) ;
        }catch(QueryException $qEx){
            return redirect()->back()->withErrors(__('home.Your data wasn\'t saved. Please try again or contact the owner')) ;
        }catch(\Throwable $e){
            return redirect()->back()->withErrors(__('home.Your data wasn\'t saved. Please contact the owner')) ;

        }

    }

    public function destroy( $id)
    {
         try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:vendors,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Vendor::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($vendor = Vendor::find($id)){
                $vendor->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));

        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json(Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }
    }
}
