<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;




use App\Traits\Carts\convertFromCartGuestToCartTraite;
use App\Traits\RegisterTriat;

class RegisterController extends Controller
{

    use convertFromCartGuestToCartTraite , RegisterTriat ;
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
//    protected $redirectTo = '/order-checkOut';
    protected $redirectTo = RouteServiceProvider::HOME;


    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
//      $this->middleware('guest:vendor');
    }






    protected function create(array $data){
        return User::create([
            'f_name' => $data['f_name'],
            'l_name' => $data['l_name'],
            'email' => $data['email'],
            'password' => request('checkout')?  Hash::make($this-> generateStrongPassword()): Hash::make($data['password']),
        ]);
    }

    ///// override register method/////
    public function register(UserRequest $request){

        $user = $this->createNewUser($request->validated()) ;
        return $this->registered($request, $user)?: redirect($this->redirectPath());
    }


}
