<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function successResponse(array  $data){
        if(request()->ajax()){
            return response()->json($data);
        }
        return redirect()->back()->with($data);
    }
    private function errorResponse(array  $data ,int $code = 500){
        if(request()->ajax()){
            return response()->json(['message'=>trans('home.cannot home.cannot delete a category that has related child child')] , $code);
        }
        return redirect()->back()->withErrors($data);
    }



}
