<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\ContactUsRequest;
use App\Models\ContactUs;
use App\Traits\Carts\CartTrait;
use App\Traits\SeoTrait;

class ContactUsController extends Controller
{
    use CartTrait ,SeoTrait;
    public function index(){

        list($data['schema'], $data['metatags']) = $this->contactUsPageSeo();

        return view('website.contact.index' ,$data ) ;
    }


    public function saveContactUs(ContactUsRequest $request)
    {


        $contact = new ContactUs();
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->phone = $request->phone;
        $contact->message = $request->message;
        $contact->save();

        $data = array('contact' => $contact);
//        Mail::send('emails/contact_email', $data, function ($msg) use ($setting) {
//            $msg->to($setting->contact_email, 'Naguib Selim')->subject('Contact Us');
//            $msg->from(config('mail.from.address'), config('mail.from.name'));
//        });
        if($request->ajax()){
            return response()->json(['contact_message' => trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);

        }

        return back()->with(['contact_message' => trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);

    }


}
