<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\AboutStruc;
use App\Models\Blog;
use App\Models\Category;
use App\Models\Product;
use App\Models\Slider;
use App\Traits\SeoTrait;

class HomeController extends Controller
{

    use SeoTrait;

    public function index()
    {
        $data['sliders'] = Slider::active()->get();
        $data['categoriesHaveProduct'] = Category::active()->hasproducts()->with('activeProducts')->get();
        $data['productsHaveDiscount'] = Product::active()->hasStock()->hasDiscount()->get();
        $best = Product::active()->hasStock()->take(8)->orders()->get();
        $data['bestSeller'] =  $best->isEmpty() ? Product::active()->hasStock()->take(8)->get() : $best;
        $data['products'] = Product::active()->hasStock()->take(10)->inRandomOrder()->get();
        $data['about_strucs'] = AboutStruc::active()->get();
        list($data['schema'], $data['metatags']) = $this->homePageSeo();
        return view('website.home.index',$data);
    }



}
