<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;

use App\Models\Page;

use App\Traits\SeoTrait;

class PageController extends Controller
{

    use SeoTrait;

    public function index($pageController)
    {
        $data['page'] = Page::where('link_ar' ,$pageController)
        ->orWhere('link_en' ,$pageController)->first();
        if(!$data['page']){
            return abort(404);
        }

        list($data['schema'], $data['metatags']) = $this->pageSeo($pageController);

        return view('website.pages.show',$data);
    }

}
