<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\ReviewRequest;
use App\Models\Category;
use App\Models\Page;
use App\Models\Product;
use App\Models\ProductReview;
use App\Traits\SeoTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{


    use SeoTrait;

    public function index()
    {
        $data['categoriesFilter'] = Category::active()->hasProducts()->get();
        $data['products'] = Product::active()->hasStock()->filterProduct()->paginate(50)->appends(request()->query());
        $data['inStock'] = Product::active()->stockInWarehouse()->count();
        $data['outOfStock'] = Product::active()->stockNotInWarehouse()->count();
        $data['all'] = Product::active()->hasStock()->count();
        list($data['schema'], $data['metatags']) = $this->productsPageSeo();

        return view('website.products.index',$data);
    }


    public function bestSeller()
    {

        $best = Product::active()->hasStock()->filterProduct()->orders()->paginate(50)->appends(request()->query());
        $data['products'] = /*$best->isEmpty()? Product::active()->hasStock()->filterProduct()->paginate(50)->appends(request()->query()):*/ $best ;

        $data['categoriesFilter'] = Category::active()->hasProducts()->get();
        $data['inStock'] = Product::active()->hasStock()->filterProduct()->orders()->stockInWarehouse()->count();
        $data['outOfStock'] = Product::active()->hasStock()->filterProduct()->orders()->stockNotInWarehouse()->count();
        $data['all'] = Product::active()->hasStock()->filterProduct()->orders()->count();
        list($data['schema'], $data['metatags']) = $this->productsPageSeo();
        return view('website.products.index',$data);
    }

    public function offers()
    {
        $data['categoriesFilter'] = Category::active()->hasProducts()->get();
        $data['inStock'] = Product::active()->hasStock()->filterProduct()->orders()->stockInWarehouse()->count();
        $data['outOfStock'] = Product::active()->hasStock()->filterProduct()->orders()->stockNotInWarehouse()->count();
        $data['all'] = Product::active()->hasStock()->filterProduct()->orders()->count();
        $best = Product::active()->hasStock()->filterProduct()->hasDiscount()->paginate(50)->appends(request()->query());
        $data['products'] = $best->isEmpty()? Product::active()->hasStock()->filterProduct()->paginate(50)->appends(request()->query()): $best ;
        list($data['schema'], $data['metatags']) = $this->productsPageSeo();
        return view('website.products.index',$data);
    }


    public function show($link)
    {
        $productInfo = Product::link($link)->with(['stocks','category','discount','reviews'])->first();
        $data['productInfo'] =  $productInfo ;
        $data['salesCount'] =  $this->getNumberOfSales($productInfo->id) ;
        $data['pagesInproductDetails'] =  Page::where('show_in_product_details' , '1')->get() ;

        $data['relatedProducts'] =  Product::active()->hasStock()->where('category_id', $productInfo->category_id )->take(20)->get() ;
        list($data['schema'], $data['metatags']) = $this->productPageSeo( $productInfo->id);
        return view('website.product.index',$data);
    }

    private function getNumberOfSales($product_id)
    {
        $lastThreeMonth = Carbon::now()->subMonths(3);
        return DB::table('order_products as op') ->
            join('product_stock as ps' ,'op.product_stock_id','=' , 'ps.id')->
            join('products as p', 'ps.product_id','=', 'p.id')->
            where('op.created_at' , '>=' , $lastThreeMonth)->
            where('p.id' ,'=', $product_id)->count();
    }


    public function saveReview(ReviewRequest $request,$link)
    {
        $product = Product::link($link)->first();
        $checkIfUserReated = $product->reviews()->where( 'user_id' ,auth()->user()->id)->exists() ;
        if(! $checkIfUserReated){
            $data = $request->validated() ;
            $data['user_id'] = auth()->user()->id ;
            $product->reviews()->create($data);
            return redirect()->back()->with('success' ,__('home.rating_added')) ;
        }
       return  redirect()->back()->withErrors(__('home.already_rated')) ;

    }
    
    public function productGoogleTage($stock_id)
    {
        $product = Product::whereHas('stocks' , function($q)use($stock_id){
            $q->where('id' , $stock_id);
        })->first();
           
       return  response()->json(['product' => [
           'id' => $product->id ,
           'name' => $product->name ,
           'net_price' => $product->net_price
           ]]) ;

    }

}
