<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Service;
use App\Traits\SeoTrait;

class ServiceController extends Controller
{

    use SeoTrait;

    public function index()
    {
        $data['services'] = Service::active()->get();
        list($data['schema'], $data['metatags']) = $this->servicesPageSeo();
        return view('website.services.index',$data);
    }

    public function show($link)
    {
        $data['service'] = Service::where('link_ar' ,$link)->orWhere('link_en' ,$link)->first();
        $data['relatedServices'] = Service::whereNot('link_ar' ,$link)->orWhereNot('link_en' ,$link)->take(10)->get();
        if(!$data['service']){
            return abort(404) ;
        }
        list($data['schema'], $data['metatags']) = $this->servicePageSeo($link);
        return view('website.services.show',$data);
    }


}
