<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BrandsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true; // Check if user has any role from the array

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name_ar' => 'required|string|max:255|unique:brands,name_ar,' . $this->route('brand'),
            'name_en' => 'required|string|max:255|unique:brands,name_en,' . $this->route('brand'),
            'order' => 'nullable|integer',
            'text_ar' => 'nullable|string',
            'text_en' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,gif,bmp,webp|max:1024',
            'icon' => 'nullable|image|mimes:jpeg,png,gif,bmp,webp|max:1024',  
            'status' => 'nullable|string|max:255',
            'link_ar' => 'required|string|max:255|unique:brands,link_ar,' .$this->route('brand'),
            'link_en' => 'required|string|max:255|unique:brands,link_en,' . $this->route('brand'),
            'mete_title_ar' => 'nullable|string|max:255',
            'mete_title_en' => 'nullable|string|max:255',
            'mete_description_ar' => 'nullable|string',
            'mete_description_en' => 'nullable|string',
            'index' => 'nullable|boolean',
        ];
    }

}
