<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VendorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
             'name_ar' => 'required|string|max:255|unique:vendors,name_ar,'.$this->route('vendor')?->id,
            'name_en' => 'required|string|max:255|unique:vendors,name_en,'.$this->route('vendor')?->id,
            'country_id' => 'nullable|exists:countries,id',
            'region_id' => 'nullable|exists:regions,id',
            'area_id' => 'nullable|exists:areas,id',
            'address' => 'nullable|string|max:255',
            'phone' => 'nullable|string|max:100',
            'logo' => 'nullable|image|mimes:jpeg,png,gif,bmp,webp|max:1024',
        ];
    }
}
