<?php

namespace App\Imports;

use App\Models\Category;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CategoryImport implements ToCollection  ,WithHeadingRow, WithValidation
{


  public function collection(Collection $rows)
    {


        foreach ($rows as $row) {
            $data = [];
            foreach ($row as $key => $value) {
                $data[$key] = $value ;
            }

            Category::create($data);
        }


    }
    
     /**
     * Define validation rules
     */
    public function rules(): array
    {
        return [
            'name_ar' => 'required|string|max:255|unique:categories,name_ar' ,
            'name_en' => 'required|string|max:255|unique:categories,name_en' ,
            'order' => 'nullable|integer',
            'parent_id' => 'nullable|exists:categories,id', // Validate that the parent category exists
            'text_ar' => 'nullable|string',
            'text_en' => 'nullable|string',
            'status' => 'nullable|string|max:255',
            'link_ar' => 'required|string|max:255|unique:categories,link_ar' ,
            'link_en' => 'required|string|max:255|unique:categories,link_en',
            'mete_title_ar' => 'nullable|string|max:255',
            'mete_title_en' => 'nullable|string|max:255',
            'mete_description_ar' => 'nullable|string',
            'mete_description_en' => 'nullable|string',
            'index' => 'nullable|boolean',
        ];
    }

    /**
     * Customize validation messages (optional)
     */
    public function customValidationMessages()
    {
        return [
            
        ];
    }

}
