<?php
namespace App\Mails;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendPassword extends Mailable implements ShouldQueue
{
    use  SerializesModels, Queueable;

    public $data; // Pass data to the email view

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function build()
    {
        return $this->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
                    ->subject('A password has been created for you. Please use it to follow your order')
                    ->view('emails.send_password') // HTML view
                    ->with(['data' => $this->data]); // Pass data to the view
    }
}
