<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory;
    private $lang ;
    protected $fillable = [
        'title_ar',
        'title_en',
        'order',
        'text_ar',
        'text_en',
        'image',
        'icon',
        'status',
        'link_ar',
        'link_en',
        'mete_title_ar',
        'mete_title_en',
        'mete_description_ar',
        'mete_description_en',
        'index',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function delete()
    {
        SaveImageTo3Path::deleteImage($this->image,'brands');
        SaveImageTo3Path::deleteImage($this->icon,'brands');
        return parent::delete();
    }
    public function getTitleAttribute(){
        return $this->{'title_'.$this->lang} ;
    }

    public function getTextAttribute(){
        return $this->{'text_'.$this->lang} ;
    }

    public function getLinkAttribute(){
        return $this->{'link_'.$this->lang} ;
    }

    public function getImageSourceAttribute($value){

        return Helper::imageIsExists($this->image ,'blogs') ?  Helper::uploadedImagesPath('blogs',$this->image)   : Helper::noImage() ;

    }

    public function getImage200Attribute($value){

        return Helper::imageIsExists($this->image ,'blogs') ?  Helper::uploadedImages200Path('blogs',$this->image)  : Helper::noImage();

    }

    public function getIconSourceAttribute(){

        return Helper::imageIsExists($this->icon ,'blogs') ? Helper::uploadedImagesPath('blogs',$this->icon) : Helper::noImage();
    }

    public function getIcon200Attribute(){

        return Helper::imageIsExists($this->icon ,'blogs') ?Helper::uploadedImages200Path('blogs',$this->icon) : Helper::noImage();
    }

    public function scopeActive($query){
        $query->whereStatus(1);
     }

     public function scopeUnactive($query){
        $query->whereStatus(0);
     }
}
