<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Page extends Model
{
    protected $table = 'pages';
    private $lang ;
    protected $fillable = [
        'title_ar',
        'title_en',
        'text_ar',
        'text_en',
        'link_ar',
        'link_en',
        'mete_title_ar',
        'mete_title_en',
        'mete_description_ar',
        'mete_description_en',
        'status',
        'show_in_product_details',
        'index',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }
    public function getTitleAttribute(){
        return $this->{'title_'.$this->lang} ;
    }
    
    public function getLinkAttribute(){
        return $this->{'link_'.$this->lang} ;
    }


    public function getTextAttribute(){
        return $this->{'text_'.$this->lang} ;
    }

    public function getActiveAttribute(){
        $this->status ? __('home.yes') : __( 'home.no') ;
     }

     public function scopeActive($query){
         $query->whereStatus(1);
      }

      public function scopeUnactive($query){
         $query->whereStatus(0);
      }
}
