<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductAttribute extends Model
{

    use HasFactory;
    protected $table = 'product_attributes';

    protected $fillable = [
        'product_id',
        'attribute_id',
    ];


    public function product(){
        return $this->belongsTo(Product::class);
    }

    public function attribute(){
        return $this->belongsTo(Attribute::class);
    }

    public function getAttributeNameAttribute(){
        return $this->attribute?->name;
    }


    public function values(){
        return $this->hasMany(ProductAttributeValue::class);
    }

    public function getAllValuesAttribute(){
       return $this->attribute?->values;
    }

}
