<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleRequest extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'email',
        'phone',
        'message',
        'is_read',
    ];

    public static function messageCount(){
	    return self::where('is_read',0)->count();
	}


    public  function getBgGroundAttribute($value){
	    return $this->is_read ? 'bg-light' : '';
	}
}
