<?php
namespace App\Traits\Products\Website;

use Illuminate\Database\Eloquent\Builder;
use App\Models\ProductStock;

use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use ReflectionClass;

trait ProductFilterTrait {

    public function scopeFilterProduct($query) {

        $methods = (new ReflectionClass($this))->getMethods(\ReflectionMethod::IS_PRIVATE);

        foreach ($methods as $method) {

            if ($method->class === __CLASS__ && str_starts_with($method->name, 'by')) {

                $this->{$method->name}($query);
            }
        }
    }

    private function byValue(Builder $product) {
        $value = request('value');
        if ($value) {
            $product->with(['attributes' => function ($query) use ($value) {
                $query->whereHas('values', function($q) use($value){
                    $q->where('value_id',$value);
                });
            }])->whereHas('attributes', function ($query) use ($value) {
                $query->whereHas('values', function($q) use($value){
                    $q->where('value_id',$value);
                });
            });
        }
    }


    private function byMinPrice( Builder $product) {
        $min_price = request('min_price');

        if ($min_price) {
            $product->with(['stocks' => function ($query) use ($min_price) {
                $query->where('price', '>=' , $min_price);
            }])->whereHas('stocks' , function ($query) use ($min_price) {
                $query->where('price', '>=' , $min_price);
            });
        }
    }

    private function byMaxPrice( Builder $product) {
        $max_price = request('max_price')  ;
        if ($max_price) {
            $product->with(['stocks' => function ($query) use ($max_price) {
                $query->where('price', '<=' , $max_price);

            }])->whereHas('stocks' , function ($query) use ($max_price) {
                $query->where('price', '<=' , $max_price);
            });
        }
    }

    private function bySortMinPrice(Builder $product)
    {
        $sort = request('sort'); // Retrieve the 'sort' parameter from the request

        if ($sort === 'min') { // Check if the user wants to sort by minimum price
            $product->orderBy(
                ProductStock::select('price')
                    ->whereColumn('products.id', 'product_stock.product_id') // Ensure column names are correct
                    ->orderBy('price', 'asc') // Sort by the minimum price
                    ->limit(1)
            );
        }

        return $product; // Return the modified query
    }



    private function bySortMaxPrice(Builder $product)
    {
        $sort = request('sort'); // Retrieve the 'sort' parameter from the request

        if ($sort === 'max') { 
            $product->orderBy(
                ProductStock::select('price')
                    ->whereColumn('products.id', 'product_stock.product_id') // Ensure correct foreign key
                    ->orderBy('price', 'desc') // Get the maximum price
                    ->limit(1)
            ,'desc');
        }

        return $product; // Return the modified query
    }
    
    private function byLatest( Builder $product) {
        $latest = request('sort') == 'new' ? request('sort') : '' ;
        if ($latest) {
            $product->latest();
        }
    }

    private function byAToZ( Builder $product) {
        $atz = request('sort') == 'atz' ? request('sort') : '' ;
        if ($atz) {
            $product->orderBy('name_'.LaravelLocalization::getCurrentLocale());
        }
    }

    private function byZToA( Builder $product) {
        $zta = request('sort') == 'zta' ? request('sort') : '' ;
        if ($zta) {
            $product->orderByDesc('name_'.LaravelLocalization::getCurrentLocale());
        }
    }

    private function byBestSeller( Builder $product) {
        $best = request('sort') == 'best' ? request('sort') : '' ;
        if ($best) {
            $product->orders();
        }
    }


    private function byAvailability( Builder $product) {
        $availability = request('availability');
        if ($availability == 'doesntHaveStock') {
            $product->whereHas('stocks' ,function($q){
                $q->where('stock' , '=' , 0) ;
            });
        }elseif ($availability == 'hasStock') {
            $product->whereHas('stocks' ,function($q){
                $q->where('stock' , '>' , 0) ;
            });
        }
    }
    
    private function byCategory( Builder $product) {
        $category = request('category');
        if($category){
            $product->whereHas('category' ,function($q) use($category){
                $q->where('link_ar' ,$category )->
                orWhere('link_en',$category);
            });
            
        }
        
        
    }
    
    private function byBrand( Builder $product) {
        $brand = request('brand');
        if($brand){
            $product->whereHas('brand' ,function($q) use($brand){
                $q->where('link_ar' ,$brand )->
                orWhere('link_en',$brand);
            });
        }
        
        
    }
    private function bySearch( Builder $product) {
        $availability = request('search');
        if ($availability) {
            $product->where('name_ar' ,'like' ,"%$availability%" )->orWhere('name_en' ,'like' ,"%$availability%" )
            ->orWhereHas('category',function($q) use($availability){
                  $q->where('name_ar' ,'like' ,"%$availability%" )->orWhere('name_en' ,'like' ,"%$availability%" );
            })
            ->orWhereHas('brand',function($q) use($availability){
                  $q->where('name_ar' ,'like' ,"%$availability%" )->orWhere('name_en' ,'like' ,"%$availability%" );
            });
        }
    }


}
