<?php

namespace App\Traits;

use App\Helpers\Helper;

use App\Models\User;
use App\Traits\Carts\ConvertFromCartGuestToCartTraite;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mails\SendPassword;
trait RegisterTriat
{
    use ConvertFromCartGuestToCartTraite ;

    public function createNewUser($user_request){
        $user = User::where('email',$user_request['email'])->first() ;
        if(!$user){
            $user_request['password']  = $this->generatePassifNotExsitsAndEncrept($user_request['password'] );
            $user =  User::create($user_request); 
        }
        auth()->login($user);
        $this->guestOperations();
        return $user ;
    }


    protected function  encreptPassword(&$password) {
        return Hash::make($password) ;
    }

    protected function  generateStrongPassword($length = 12) {
        $uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $lowercase = 'abcdefghijklmnopqrstuvwxyz';
        $numbers = '0123456789';
        $specialCharacters = '!@#$%^&*()-_=+[]{}|;:,.<>?';

        $allCharacters = $uppercase . $lowercase . $numbers . $specialCharacters;
        $password = '';
        // Ensure at least one character from each set is included
        $password .= $uppercase[random_int(0, strlen($uppercase) - 1)];
        $password .= $lowercase[random_int(0, strlen($lowercase) - 1)];
        $password .= $numbers[random_int(0, strlen($numbers) - 1)];
        $password .= $specialCharacters[random_int(0, strlen($specialCharacters) - 1)];
        // Fill the rest of the password length with random characters from all sets
        for ($i = 4; $i < $length; $i++) {
            $password .= $allCharacters[random_int(0, strlen($allCharacters) - 1)];
        }
        // Shuffle the characters to ensure randomness

        $password = str_shuffle($password);
        try {
            // Helper::SendEmail(request('email') ,"A password has been created for you. Please use it to follow your order: $password " ,env('APP_NAME')) ;
            $data=[
                'name' => request('f_name'),
                'password' => $password ,
                ];
            Mail::to(request('email'))->queue(new SendPassword($data));
        } catch (\Exception $e) {

        }
        return $password ;
    }

    protected function  generatePassifNotExsitsAndEncrept(&$password ,$length = 12) {
        if($password){
            return $this->encreptPassword($password) ;
        }

        $password = $this->generateStrongPassword($length );

        return $this->encreptPassword( $password) ;
    }




}
