@extends('layouts.admin')
@section('meta')
<title>{{trans('home.edit')}}  {{trans('home.branch')}}</title>
@endsection
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.branches')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/branches')}}">{{trans('home.branches')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit')}}</li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a href="{{LaravelLocalization::localizeUrl('admin/branches/'.$branch->id.'/get-phones') }}" ><button class="btn ripple btn-info"><i class="fas fa-phone"></i> {{trans('home.show')}}</button></a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit')}}</h6>
                        </div>
                        {!! Form::open(['method'=>'PATCH','url' => route('branches.update', $branch->id  ), 'data-toggle'=>'validator', 'files'=>'true']) !!}
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.name_en')}}</label>
                                    <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}"  value="{{$branch->name_en}}" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.name_ar')}}</label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{$branch->name_ar}}" required>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.email')}}</label>
                                    <input class="form-control" name="email" type="text" value="{{$branch->email}}" placeholder="{{trans('home.email')}}"  >
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.order')}}</label>
                                    <input class="form-control"  name="order" type="text" value="{{$branch->order}}" placeholder="{{trans('home.order')}}"  >
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.address_en')}}</label>
                                    <input class="form-control" name="address_en" type="text" placeholder="{{trans('home.address_en')}}"  value="{{$branch->address_en}}" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.address_ar')}}</label>
                                    <input class="form-control" name="address_ar" type="text" placeholder="{{trans('home.address_ar')}}" value="{{$branch->address_ar}}" required>
                                </div>


                                <div class="form-group col-md-12">
                                    <label class="">{{trans('home.map_url')}}</label>
                                    <textarea class="form-control " name="map_url" type="text" placeholder="{{trans('home.map_url')}}">{{$branch->map_url}}</textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" {{($branch->status == 1)? 'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                    </label>
                                </div>


                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{url('/admin/branches')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>

                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
