@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.phones') }}</title>
@endsection
@section('content')
    <div class="spainer"></div>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.phones') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ url('/admin') }}"> {{ trans('home.admin') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ url('admin/branches') }}">{{ trans('home.branches') }} </a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/branches/' . $branch->id.'/edit') }}">{{ $branch->name }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.phones') }}</li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a id="btn_delete"  ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <form action="{{ url('admin/branches/'.$branch->id.'/store-phone', ) }}" method="post">
                            <div class="row">
                                @csrf
                                <div class="form-group col-md-12">
                                    <label class="">{{ trans('home.phone') }}</label>
                                    <input class="form-control" name="phone" type="text" placeholder="{{ trans('home.phone') }}" value="{{request()->method() == 'post' ? old('phone') : ''}}" >
                                </div>
                                <div class="form-group col-md-12">
                                    <label class="">{{ trans('home.title_ar') }}</label>
                                    <input class="form-control" name="title_ar" type="text" placeholder="{{ trans('home.title_ar') }}" value="{{request()->method() == 'post' ? old('title_ar') : ''}}" >
                                </div>
                                <div class="form-group col-md-12">
                                    <label class="">{{ trans('home.title_en') }}</label>
                                    <input class="form-control" name="title_en" type="text" placeholder="{{ trans('home.title_en') }}" value="{{request()->method() == 'post' ? old('title_en') : ''}}" >
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"> {{trans('home.save')}} </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.phones') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}
                            </p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll" /></th>
                                        <th>#</th>
                                        <th class="wd-25p">{{ trans('home.phone') }}</th>
                                        <th class="wd-20p">{{ trans('home.edit') }}</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    @foreach ($branch->phones as $key => $phone)
                                        <tr id="{{ $phone->id }}" >
                                            <td>
                                                <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $phone->id }}" />
                                            </td>
                                            <td> {{ $key + 1 }} </td>

                                            <td> {{ $phone->phone }}  </td>
                                            <td>
                                                <button type="button"  class="btn btn-info" data-toggle="modal" data-target="#stockForm_{{$key}}"><i class="fas fa-edit"></i></button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        @foreach ($branch->phones as $key => $phone)
            <div class="modal fade text-left" id="stockForm_{{ $key }}" tabindex="-1" role="dialog"
                aria-labelledby="myModalLabel34" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3 class="modal-title" id="myModalLabel34">{{ trans('home.edit_phone') }}</h3>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('phones.update', $phone->id ) }}" method="post">
                            @method('PATCH')
                            @csrf
                            <div class="modal-body">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label>{{ trans('home.phone') }}</label>
                                        <input type="text" class="form-control" placeholder="{{ trans('home.phone') }}" name="phone" value="{{ $phone->phone }}">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label class="">{{ trans('home.title_ar') }}</label>
                                        <input class="form-control" name="title_ar" type="text" placeholder="{{ trans('home.title_ar') }}" value="{{$phone->title_ar}}" >
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label class="">{{ trans('home.title_en') }}</label>
                                        <input class="form-control" name="title_en" type="text" placeholder="{{ trans('home.title_en') }}" value="{{$phone->title_en}}" >
                                    </div>
                                    <div class="form-group col-md-12">
                                        <button type="submit" class="btn btn-info">{{ trans('home.update') }} </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
    @endsection
