@extends('layouts.admin')
<title>{{trans('home.order_details')}}</title>
@section('style')
    <style type="text/css">
        #loader {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        width: 100%;
        background: rgba(0,0,0,0.75) url(https://mix-cosmetic.com/resources/assets/back/img/loader.gif) no-repeat center center;
        z-index: 10000;
        }
    </style>
@endsection
@section('content')

<div id="loader"></div>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.order_details')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/orders')}}">{{trans('home.orders')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.order_details')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">

                        <div aria-multiselectable="true" class="accordion" id="accordion" role="tablist">
                            <div class="card">
                                <div class="card-header" id="headingOne" role="tab">
                                    <a aria-controls="collapseOne" aria-expanded="false" data-toggle="collapse" href="#collapseOne" class="collapsed">{{trans('home.order_details')}}</a>
                                </div>
                                <div aria-labelledby="headingOne" class="collapse" data-parent="#accordion" id="collapseOne" role="tabpanel" style="">
                                    <div class="card-body">
                                        <div class="order_details">
                                            <div class="row">
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.tracking_code')}} :</strong>  {{$order->number}}</p></div>
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.order_date')}} :</strong> {{date('Y-m-d', strtotime($order->created_at ))}}</p></div>
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.address')}} :</strong>@if($order->address) {{$order->address_full}} @else {{trans('home.unknow_address')}} @endif</p></div>
                                                {{-- <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.payment_status')}} :</strong>  {{trans("home.$order->payment_status")}}</p></div> --}}
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.payment_method')}} :</strong> {{ __("home.$order->payment_method")}}</p></div>
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.shipping_method')}} :</strong> {{ __("home.$order->shipping_method")}}</p></div>
                                                {{-- @if($order->payment_method_fees) <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.payment_method_fees')}} :</strong> {{$order->payment_method_fees}} {{trans("home.EGP")}} </p></div> @endif --}}
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.shipping_fees')}} :</strong> {{$order->shipping_fees ?? 0}} {{trans("home.EGP")}} </p></div> 
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.products_price')}} :</strong> {{$order->products_price ?? 0}} {{trans("home.EGP")}} </p></div> 
                                                <div class="col-sm-12 col-md-6"><p><strong>{{trans('home.coupoun_discount')}} :</strong> {{$order->coupoun_discount ?? 0}} {{trans("home.EGP")}} </p></div> 
                                                <div class="col-sm-12 col-md-12"><p><strong>{{trans('home.order_note')}} :</strong> {{$order->order_note}}</p></div>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="table-responsive-sm order-table">
                                            <table class="bg-white table table-bordered table-hover text-center">
                                                <thead>
                                                    <tr>
                                                    	<th class="text-left">{{trans('home.image')}}</th>
                                                        <th class="text-left">{{trans('home.name')}}</th>
                                                        <th>{{trans('home.unit_price')}}</th>
                                                        <th>{{trans('home.discount')}} {{trans('home.per_unit')}}</th>
                                                        <th>{{trans('home.quantity')}}</th>
                                                        <th>{{trans('home.price')}}</th>
                                                        <th>{{trans('home.discount_total')}}</th>
                                                        <th>{{trans('home.subtotal')}}</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                   @forelse($order->products as $product)
                                                        <tr>
                                                            <td>
                                                                <a href="{{url('admin/products/'.$product->product_id.'/edit')}}" class="thumb">
                                                                    <img width="60px" class="checkout-image" src="{{ $product->product_main_image}}">
                                                                </a>
                                                            </td>
                                                            <td class="text-left">
                                                                <a href="{{url('admin/products/'.$product->product_id.'/edit')}}" class="thumb">
                                                                    {{ $product->product_name}}
                                                                </a>
                                                            </td>
                                                            <td>{{$product->price}}</td>
                                                            <td>{{$product->product_discount}}</td>
                                                            <td>{{$product->quantity}}</td>
                                                            <td>
                                                                <span>{{$product->price * $product->quantity }} {{trans('home.EGP')}}</span>
                                                            </td>
                                                            <td>{{$product->product_discount * $product->quantity }}</td>
                                                            <td>{{$product->total}} {{trans('home.EGP')}}</td>
                                                        </tr>
                                                            
                                                    @empty
                                                        <tr>
                                                            <td colspan="5">{{trans('home.order_item_not_availbale_now')}}</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>

                        <div>
                            <h6 class="card-title mb-1">{{trans('home.order_tracking')}}</h6>
                        </div>

                        <div class="form-wizard-steps order-tracking">

                        	<div class="form-wizard-progress">
                    			    <div class="form-wizard-progress-line" data-now-value="12.25" data-number-of-steps="4" style="width: 12.25%;"></div>
                    		</div>

                            <div class="step-track">
                                <div class="step-icon">
                                    <button type="button" class="btn btn-primary track-order" disabled>
                                    	<img style="display:none;"  src="{{url('resources/assets/back/img/box.png')}}">
                                    	<i class="fa fa-unlock-alt"></i>
                                    </button>
                                </div>
                                <p>{{trans('home.pending')}}</p>
                            </div>


                            <div class="step-track">
                                <div class="step-icon">
                                    <button type="button" class="btn btn-primary track-order" data-status="accept" @if( 'pending' != $order->status_current ) disabled @endif>
                                    	<img style="display:none;" src="{{url('resources/assets/back/img/check.png')}}">
                                    	<i class="fa fa-check"></i>
                                    </button>
                                </div>
                                <p>{{trans('home.accept')}}</p>
                            </div>

                            <div class="step-track">
                                <div class="step-icon">
                                    <button type="button" class="btn btn-primary track-order" data-status="process" @if( 'accept' != $order->status_current) disabled @endif>
                                    	<img style="display:none;" src="{{url('resources/assets/back/img/hourglass.png')}}">
                                   		<i class="fa fa-recycle"></i>
                                    </button>
                                </div>
                                <p>{{trans('home.process')}}</p>
                            </div>


                            <div class="step-track">
                                <div class="step-icon">
                                    <button  type="button" class="btn btn-primary track-order" data-status="shipping" @if('process' != $order->status_current) disabled @endif>
                                    	<img style="display:none;" src="{{url('resources/assets/back/img/truck.png')}}">
                                    	<i class="fa fa-shipping-fast"></i>
                                    </button>
                                </div>
                                <p>{{trans('home.shipping')}}</p>
                            </div>

                             <div class="step-track">
                                <div class="step-icon">
                                    <button type="button" class="btn btn-primary track-order" data-status="delivered" @if('shipping' != $order->status_current ) disabled @endif>
                                    	<img style="display:none;" src="{{url('resources/assets/back/img/like.png')}}">
                                    	<i class="fa fa-handshake"></i>
                                    </button>
                                </div>
                                <p>{{trans('home.delivered')}}</p>
                            </div>

                        </div>

                        <br>
                        <div class="table-responsive">
                            <table class="table mg-b-0">
                                <thead>
                                    <tr>
                                        <th>{{trans('home.date')}}</th>
                                        <th>{{trans('home.time')}}</th>
                                        <th>{{trans('home.status')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($order->orderStatus as $status)
                                        <tr>
                                            <th scope="row">{{date('Y/m/d', strtotime($status->created_at ))}}</th>
                                            <td>{{date('h:i:s', strtotime($status->created_at ))}}</td>
                                            <td>{{trans("home.$status->status")}}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>

                    </div>

                    <div class="card-footer text-right">
                        <a href="{{url('admin/order/'.$order->id.'/invoice')}}" target="_blank">
                            <button type="button" class="btn ripple btn-primary mb-1"><i class="fe fe-credit-card mr-1"></i>{{trans('home.generate_invoice')}}</button>
                        </a>
                    </div>
                    <div class="card-footer text-left">
                        <form @if( 'canceled' !=  $order->orderStatus->toArray()) action="{{url('admin/orders/changeStatus')}}" method="POST" @endif>
                            @csrf
                            <div class="input-group mb-3">
                                <input type="hidden" name="status" value="canceled">
                                <input type="hidden" name="orderId" value="{{$order->id}}">

                                <button  @if('canceled' == $order->status_current) disabled @endif  class="btn btn-outline-secondary" type="submit" id="button-addon1">{{trans('home.cancel_order')}}</button>
                                <input type="text"  @readonly('canceled' ==  $order->orderStatus->toArray())  class="form-control" placeholder="" value="{{$order->status_current_not}}" name="note" aria-label="Example text with button addon" aria-describedby="button-addon1">
                              </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.select_order_delivery')}}</h6>
                        </div>
                        <form action="{{url('admin/order/delivery/'.$order->id)}}" method="POST">
                            @csrf
                            <div class="row align-items-center">

                                <div class="form-group col-md-5">
                                    <label for="code">{{trans('home.delivery_date')}}</label>
                                    <div class="input-group">
                                        <input type='text' class="form-control dateFrom" value="{{$order->delivery_date}}" placeholder="{{trans('home.delivery_date')}}" id="datepicker1" name="delivery_date" readonly required/>
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="fas fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group col-md-5">
                                    <label for="helperText">{{trans('home.deliver_man')}}</label>
                                    <select class="form-control select2" name="delivery_id" required>
                                        <option></option>
                                        @foreach($deliveries as $delivery)
                                            <option value="{{$delivery->id}}" {{($delivery->id == $order->delivery_id )?'selected':''}}>{{$delivery->name}} - {{$delivery->phone1}}</option>
                                        @endforeach

                                    </select>
                                </div>

                                @if(! $order->delivery_id )
                                    <div class="form-group col-md-2">
                                        <button type="submit" class="btn btn-success" style="margin-top: 25px"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    </div>
                                @endif
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>

        $(document).on({
            ajaxStart: function() { $('#loader').show();},
            ajaxStop: function() {  $('#loader').hide();}
        });

        $('.track-order').on('click',function(){
            var status = $(this).data('status');
            var orderId = "{{$order->id}}";

            $.ajax({
                url:"{{url('admin/orders/changeStatus')}}",
                method:'POST',
                data:{orderId:orderId,status:status},
                success:function(html)
                {
                    location.reload();
                }
            });
        });

        $( "#datepicker1" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });

    </script>
@endsection

