
@extends('layouts.app')
@section('meta')
<title> @lang('home.checkout')</title>
@endsection
@section('content')
    <!-- page-title -->
    @include('website.carts.banner')

    <!-- page-cart -->
    <section class="flat-spacing-11" >
        <div class="container">
            <div class="tf-page-cart-wrap layout-2">
                <div class="tf-page-cart-item">
                    <h5 class="fw-5 mb_20">@lang('home.order_details')</h5>
                    <form class="form-checkout" method="POST" id="frm-place-order" action="{{LaravelLocalization::localizeUrl('orders/place-order')}}">
                        @csrf
                        <input type="hidden" name="address_id" value="{{$user->primary_address?->id}}">
                        <div class="box grid-2">
                            <fieldset class="fieldset">
                                <label for="f_name">@lang('home.f_name')</label>
                                <input type="text" id="f_name" value="{{$user->f_name}}"  name="f_name" placeholder="@lang('home.f_name')">
                            </fieldset>
                            <fieldset class="fieldset">
                                <label for="last-name">@lang('home.l_name')</label>
                                <input type="text"  name="l_name" id="l_name" value="{{$user->l_name}}"  placeholder="@lang('home.l_name')">
                            </fieldset>
                        </div>
                        <fieldset class="box fieldset">
                            <label for="country">@lang('home.country')</label>
                            <div class="select-custom">
                                <select class="tf-select w-100 get-regions" id="country" name="country_id" >
                                    <option value="">@lang('home.country')</option>
                                    @foreach ($countries as $country)
                                        <option @selected($user?->primary_address?->country_id  == $country->id ) value="{{$country->id}}">{{$country->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="region">@lang('home.region')</label>
                            <div class="select-custom" id="region-container">
                                <select class="tf-select w-100 get-areas" id="region" name="region_id" data-default="">
                                <option value="">@lang('home.region')</option>
                                @foreach ($regions as $region)
                                    <option @selected($user?->primary_address?->region_id  == $region->id ) value="{{$region->id}}"> {{$region->name}} </option>
                                @endforeach
                            </select>
                            </div>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="region">@lang('home.area')</label>
                            <div class="select-custom" id="area-container">
                                <select class="tf-select w-100  get-shipping-fees" id="area" name="area_id" >
                                    <option value="">@lang('home.area')</option>
                                    @foreach ($areas as $area)
                                        <option @selected($user?->primary_address?->area_id == $area->id ) value="{{$area->id}}">{{$area->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="address">@lang('address')</label>
                            <input type="text" id="address" name="address" value="{{$user->primary_address?->address}}" >
                        </fieldset>
                        <fieldset class="box fieldset">
                            <label for="phone">@lang('home.phone')</label>
                            <input type="number" id="phone" name="phone" value="{{$user->phone}}"   >
                        </fieldset>
                        <fieldset class="box fieldset">
                            <label for="email">@lang('home.email')</label>
                            <input type="email" id="email" name="email"value="{{$user->email}}" >
                        </fieldset>
                        <fieldset class="box fieldset">
                            <label for="note">@lang('home.order_note') (@lang('optional'))</label>
                            <textarea name="note" id="note"> {{$user->note}} </textarea>
                        </fieldset>
                    </form>
                </div>
                <div class="tf-page-cart-footer">
                    <div class="tf-cart-footer-inner">
                        <h5 class="fw-5 mb_20">@lang('home.orders')</h5>
                        <form class="tf-page-cart-checkout widget-wrap-checkout">
                            <ul class="wrap-checkout-product">
                                @foreach ($cart->items as $item)
                                    <li class='checkout-product-item product-item {{"cart-$item->product_link"}}' data-unique-class='{{"cart-$item->product_link"}}'>
                                        <figure class="img-product">
                                            <img src="{{$item->product_main_image}}" alt="product">
                                            <span class="quantity product-quantity">{{$item->quantity }}</span>
                                        </figure>
                                        <div class="content">
                                            <div class="info">
                                                <p class="name">{{ $item->product_name}}</p>
                                                <span class="variant">{{ $item->product_category_name}}</span>
                                            </div>
                                            <span class="price"> <span class="product-total-price"> {{ $item->product_net_price }} </span> @lang('home.EGP')</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                            <div class="coupon-box">
                                <input type="text"  placeholder="Discount code" id="coupon_code">
                                <a id="send-coupon" class="tf-btn btn-sm radius-3 btn-fill btn-icon animate-hover-btn">@lang('home.applay')</a>
                            </div>
                            <div class="d-flex justify-content-between line pb_20 fees-ship">
                                <h6 class="fw-5">@lang('home.shipping_fees')</h6>
                                <h6 class="total fw-5"><span  class="shipping-fees">{{$shipping_fees}}</span> @lang('home.EGP')</h6>
                            </div>
                            <div class="d-flex justify-content-between line pb_20">
                                <h6 class="fw-5">@lang('home.total')</h6>
                                <h6 class="total fw-5"><span class="end-total" id="end-total"> {{ Helper::checkShippingFree( $cart->net_total_price , $shipping_fees ) }} </span> @lang('home.EGP')</h6>
                            </div>
                            <div class="wd-check-payment">
                                <div class="fieldset-radio mb_20">
                                    <input type="radio" name="payment" id="bank" class="tf-check">
                                    <label for="bank">@lang('home.Direct bank transfer')</label>

                                </div>
                                <div class="fieldset-radio mb_20">
                                    <input type="radio" name="payment" id="delivery" class="tf-check">
                                    <label for="delivery">@lang('home.cash_on_delivery')</label>
                                </div>
                                {{-- <p class="text_black-2 mb_20">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our <a href="privacy-policy.html" class="text-decoration-underline">privacy policy</a>.</p>
                                <div class="box-checkbox fieldset-radio mb_20">
                                    <input type="checkbox" id="check-agree" class="tf-check">
                                    <label for="check-agree" class="text_black-2">I have read and agree to the website <a href="terms-conditions.html" class="text-decoration-underline">terms and conditions</a>.</label>
                                </div> --}}
                            </div>
                            <a href="javascript:void(0)" onclick="document.getElementById('frm-place-order').submit()" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center">@lang('home.place_order')</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- page-cart -->
@endsection

@section('script')
@include('website.scripts.checkout.get-regions') ;
@include('website.scripts.checkout.get-areas') ;
@include('website.scripts.checkout.get-shipping-fees') ;
<script>
    $(function(){
        $(document).on('click' ,'#send-coupon' ,function () {
            addCouponCode()

        })
    })


    $(document).on('keydown','#coupon_code', function (e) {

        if (e.key === 'Enter') {
            e.preventDefault();
            addCouponCode()
        }
    });

    function addCouponCode() {
        let coupon_code = $('#coupon_code').val() ;
            if (!coupon_code) {
                toastr.error('{{ __("home.Enter Coupon Code") }}');

            }else{
                goToUrl("{{url('carts/add-coupon')}}?coupon_code="+coupon_code)
            }
    }
</script>



@endsection
