        <!-- tabs -->
        <section class="flat-spacing-17 pt_0">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="widget-tabs style-has-border">
                            <ul class="widget-menu-tab">
                                <li class="item-title active">
                                    <span class="inner">@lang('home.description')</span>
                                </li>
                                <li class="item-title">
                                    <span class="inner">@lang('home.reviews')</span>
                                </li>
                                @foreach ($pagesInproductDetails as $pageDetails )
                                    <li class="item-title">
                                        <span class="inner"> {{$pageDetails->title }} </span>
                                    </li>
                                @endforeach
                            </ul>
                            <div class="widget-content-tab">
                                <div class="widget-content-inner active">
                                    {!!  $product->text !!}
                                </div>
                                <div class="widget-content-inner">
                                    <div class="tab-reviews write-cancel-review-wrap">
                                        <div class="tab-reviews-heading">
                                            <div class="top">
                                                <div class="text-center">
                                                    <h1 class="number fw-6">{{$product->reviews_percentage}}</h1>
                                                    <div class="list-star">
                                                        @for ($index = 0 ; $product->reviews_avrage  > $index ; $index++)
                                                        <i class="icon icon-star"></i>
                                                        @endfor
                                                    </div>
                                                    <p>({{$product->reviews_count}} @lang('home.rate'))</p>
                                                </div>
                                                <div class="rating-score">
                                                    <div class="item">
                                                        <div class="number-1 text-caption-1">5</div>
                                                        <i class="icon icon-star"></i>
                                                        <div class="line-bg">
                                                            <div style="width: {{$product->reviews_rate5_count * $product->reviews_count * 100}}%;"></div>
                                                        </div>
                                                        <div class="number-2 text-caption-1">{{$product->reviews_rate5_count}}</div>
                                                    </div>
                                                    <div class="item">
                                                        <div class="number-1 text-caption-1">4</div>
                                                        <i class="icon icon-star"></i>
                                                        <div class="line-bg">
                                                            <div style="width: {{$product->reviews_rate4_count * $product->reviews_count * 100}}%;"></div>
                                                        </div>
                                                        <div class="number-2 text-caption-1">{{$product->reviews_rate4_count}}</div>
                                                    </div>
                                                    <div class="item">
                                                        <div class="number-1 text-caption-1">3</div>
                                                        <i class="icon icon-star"></i>
                                                        <div class="line-bg">
                                                            <div style="width: {{$product->reviews_rate3_count * $product->reviews_count * 100}}%;"></div>
                                                        </div>
                                                        <div class="number-2 text-caption-1">{{$product->reviews_rate3_count}}</div>
                                                    </div>
                                                    <div class="item">
                                                        <div class="number-1 text-caption-1">2</div>
                                                        <i class="icon icon-star"></i>
                                                        <div class="line-bg">
                                                            <div style="width: {{$product->reviews_rate2_count * $product->reviews_count * 100}}%;"></div>
                                                        </div>
                                                        <div class="number-2 text-caption-1">{{$product->reviews_rate2_count }}</div>
                                                    </div>
                                                    <div class="item">
                                                        <div class="number-1 text-caption-1">1</div>
                                                        <i class="icon icon-star"></i>
                                                        <div class="line-bg">
                                                            <div style="width: {{$product->reviews_rate1_count * $product->reviews_count * 100}}%;"></div>
                                                        </div>
                                                        <div class="number-2 text-caption-1">{{$product->reviews_rate1_count}}</div>
                                                    </div>
                                                </div>
                                            </div>
                                            @if (Helper::userCanRate($product->id))
                                                <div>
                                                    <div class="tf-btn btn-outline-dark fw-6 btn-comment-review btn-cancel-review">@lang('home.cancel')</div>
                                                    <div class="tf-btn btn-outline-dark fw-6 btn-comment-review btn-write-review">@lang('home.review')</div>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="reply-comment cancel-review-wrap">
                                            <div class="d-flex mb_24 gap-20 align-items-center justify-content-between flex-wrap">
                                                <h5 class="">{{$product->reviews->filter(fn($review) => !empty($review->comment))->count()}} @lang('home.comments')</h5>
                                                {{-- <div class="d-flex align-items-center gap-12">
                                                    <div class="text-caption-1">Sort by:</div>
                                                    <div class="tf-dropdown-sort" data-bs-toggle="dropdown">
                                                        <div class="btn-select">
                                                            <span class="text-sort-value">Most Recent</span>
                                                            <span class="icon icon-arrow-down"></span>
                                                        </div>
                                                        <div class="dropdown-menu">
                                                            <div class="select-item active">
                                                                <span class="text-value-item">Most Recent</span>
                                                            </div>
                                                            <div class="select-item">
                                                                <span class="text-value-item">Oldest</span>
                                                            </div>
                                                            <div class="select-item">
                                                                <span class="text-value-item">Most Popular</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> --}}
                                            </div>
                                            <div class="reply-comment-wrap">
                                                @foreach ($product->reviews->filter(fn($review) => !empty($review->comment)) as $review )
                                                <div class="reply-comment-item">
                                                    <div class="user">
                                                        <div class="image">
                                                            <img src="{{$review->user_image}}" alt="">
                                                        </div>
                                                        <div>
                                                            <h6>
                                                                <a href="#" class="link">{{$review->name}}</a>
                                                            </h6>
                                                            <div class="day text_black-3">{{Helper::handleDate($review->created_at)}}</div>
                                                        </div>
                                                    </div>
                                                    <p class="text_black-3"> {{$review->comment}} </p>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        @if (Helper::userCanRate($product->id))
                                        <form action="{{LaravelLocalization::LocalizeUrl('product/'.$product->link.'/review')}}" method="post" class="form-write-review write-review-wrap">
                                            <div class="heading">
                                                <h5>@lang('rate')</h5>
                                                <div class="list-rating-check">
                                                    <input type="radio" id="star5" name="rate" value="5" />
                                                    <label for="star5" title="text"></label>
                                                    <input type="radio" id="star4" name="rate" value="4" />
                                                    <label for="star4" title="text"></label>
                                                    <input type="radio" id="star3" name="rate" value="3" />
                                                    <label for="star3" title="text"></label>
                                                    <input type="radio" id="star2" name="rate" value="2" />
                                                    <label for="star2" title="text"></label>
                                                    <input type="radio" id="star1" name="rate" value="1" />
                                                    <label for="star1" title="text"></label>
                                                </div>
                                            </div>
                                            @csrf
                                            <div class="form-content">
                                                <fieldset class="box-field">
                                                    <label class="label">@lang('home.comment')</label>
                                                    <textarea rows="4" placeholder="@lang('home.comment')" tabindex="2" aria-required="true" required=""></textarea>
                                                </fieldset>
                                            </div>
                                            <div class="button-submit">
                                                <button class="tf-btn btn-fill animate-hover-btn" type="submit">@lang('home.review')</button>
                                            </div>
                                        </form>
                                        @endif
                                    </div>
                                </div>
                                <div class="widget-content-inner">
                                    @foreach ($pagesInproductDetails as $pageDetails )
                                        <div class="tf-page-privacy-policy">
                                            {!! $pageDetails->text !!}
                                        </div>
                                    @endforeach
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /tabs -->