@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection
@section('content')



    @include('website.products.banner')

            <!-- /page-title -->
        <section class="flat-spacing-1">
            <div class="container">
                @include('website.products.sort-and-preview')
                <div class="tf-row-flex">
                    @include('website.products.sidebar')
                    <div class="tf-shop-content">
                        <div class="grid-layout wrapper-shop" data-grid="grid-3">
                            @foreach ($products  as $cartProduct )
                                @include('website.card-product' , ['cartProduct' => $cartProduct , 'cartProductId' => 'products-page-'.$cartProduct->link ])
                            @endforeach
                        </div>
                        @include('website.products.pagination', ['paginator' => $products ])
                    </div>
                </div>

            </div>
        </section>
        <div class="btn-sidebar-mobile start-0 filterShop">
            <button class="type-hover">
                <i class="icon-open"></i>
                <span class="fw-5">Open Filter</span>
            </button>
        </div>
        <div class="overlay-filter" id="overlay-filter"></div>
@endsection
@section('script')
    @include('website.scripts.sort&filter.sort-products')
    @include('website.scripts.sort&filter.filter')
@endsection