@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp

    @php echo $schema @endphp
@endsection
@section('content')


@include('website.banner',['bannerTitle' => __('home.sale request') ])


        <section class="bg_grey-7 flat-spacing-9">
            <div class="container">
                <div class="flat-title">
                    <span class="title">@lang('home.contactUs')</span>
                    {{-- <p class="sub-title text_black-2">If you’ve got great products your making or looking to work with us then drop us a line.</p> --}}
                </div>
                <div>
                    <form  class="mw-705 mx-auto text-center form-contact" id="contactSubmit" action="LaravelLocalization::localizeUrl('save/contact-us')" method="post">
                        <div class="d-flex gap-15 mb_15">
                            <fieldset class="w-100">
                                <input type="text" name="name" id="name"  placeholder="@lang('home.name') *"/>
                            </fieldset>
                            <fieldset class="w-100">
                                <input type="text" name="phone" id="phone"  placeholder="@lang('home.phone') *"/>
                            </fieldset>
                        </div>
                        <div class="d-flex gap-15 mb_15">
                            <fieldset class="w-100">
                                <input type="email" name="email" id="email"  placeholder="@lang('home.email') *"/>
                            </fieldset>
                        </div>
                        <div class="mb_15">
                            <textarea placeholder="Message" name="message" id="message"  cols="30" rows="10"></textarea>
                        </div>
                        @csrf
                        <div class="send-wrap">
                            <button type="submit" class="tf-btn radius-3 btn-fill animate-hover-btn justify-content-center">Send</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
        <!-- /form -->
        <!-- Footer -->
@endsection

@section('script')
@include('website.scripts.show-message', [
  'formName' => '#contactSubmit',
  'urlForm' => LaravelLocalization::localizeUrl('sale-requests'),
])

@endsection
