<script>
    $(function () {
        $(document).on('click', ".minus-btn", function (e) {
            var element = $(this);
            let quantity = element.closest('.product-item').find('.product-quantity').val()
            updateProductInCart($(this), function (success) {
                if (success) {

                    let price = element.closest('.product-item').find('.product-price').text()
                    let unique_class_name = element.closest('.product-item').data('unique-class');

                    let unique_class = $('.'+ unique_class_name ) ;
                    unique_class.find('.product-total-price').text((price * quantity).toFixed(2))
                    unique_class.find('.product-quantity').val(quantity)
                }else{
                     element.closest('.product-item').find('.product-quantity').val(quantity + 1 )
                     element.data('quantity', $quantity + 1)
                }
            });
        });

        $(document).on('click', ".plus-btn", function (e) {
            var element = $(this);
            let quantity = element.closest('.product-item').find('.product-quantity').val()
            updateProductInCart($(this), function (success) {
                if (success) {

                    let unique_class_name = element.closest('.product-item').data('unique-class');
                    let price = element.closest('.product-item').find('.product-price').text()

                    let unique_class = $('.'+ unique_class_name ) ;
                    unique_class.find('.product-total-price').text((price * quantity).toFixed(2))
                    unique_class.find('.product-quantity').val(quantity)

                }else{
                    element.closest('.product-item').find('.product-quantity').val(quantity - 1)
                    element.data('quantity', $quantity -1 )
                }
            });
        });

        $(document).on('change', ".quantity-input", function (e) {
            current_element = $(this) // quantoty input

            // minus btn, to make change to its quantity data , and can pass it or plus btn to update cart function ;
            let minus_element = $(this).closest('.wg-quantity').find('.minus-btn') ;

            // plus btn, to make change to its quantity data , and can pass it or minus btn to update cart function ;
            let plus_element = $(this).closest('.wg-quantity').find('.plus-btn') ;

            let oldQuantity = minus_element.data('quantity') ;// to set old quantity if functoin return false ;
            let newQuantity = $(this).val() ;

            minus_element.data('quantity', newQuantity) // pass new quntity to the element data quantity
            updateProductInCart(minus_element,function (success) {
                if (success) {
                    // get uniq class to change prduct quantity in sidebar cart cart cart page
                    let unique_class_name = current_element.closest('.product-item').data('unique-class');

                    let price = current_element.closest('.product-item').find('.product-price').text();

                    // get all parent has this product
                    let unique_class = $('.'+ unique_class_name ) ;


                    unique_class.find('.product-total-price').text((price * newQuantity).toFixed(2))
                    unique_class.find('.product-quantity').val(newQuantity)
                    plus_element.data('quantity', newQuantity)
                    minus_element.data('quantity', oldQuantity)
                }else{
                    current_element.val(oldQuantity)
                    plus_element.data('quantity', oldQuantity)
                    minus_element.data('quantity', oldQuantity)

                }
            });
        });
    });

    function updateProductInCart($element ,callback) {
        var data = {
                product_stock_id: $element.data('stock_id'),
                quantity: $element.data('quantity')

            };

        $.ajax({
            url: '{{LaravelLocalization::localizeUrl("carts")}}',
            method: 'PATCH',
            data: data,
            success: function (response) {
                toastr.success(response.message)
                @if(url()->current() == LaravelLocalization::localizeUrl('checkout') )
                     getProduct(data.product_stock_id,data.quantity)

                    goToUrl('{{url()->full()}}')
                @else
                    getCart();
                    // show coupon errors
                    getProduct(data.product_stock_id,data.quantity)

                    if(response.wrong_messages.error){
                        for (let index = 0; index < response.wrong_messages.error.length; index++) {
                            const wrong_message = response.wrong_messages.error[index];
                            toastr.warning(wrong_message)
                        }
                    }

                @endif
                callback(true); // Pass `true` to the callback on success

            },
            error: function (xhr, status, error) {
                errorMessage(xhr, status, error)
                callback(false); // Pass `false` to the callback on error

            }
        });
    }




</script>