<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Service extends Model
{
    protected $guarded = [];

    public static function setCurrentLang()
    {
        return app()->getLocale();
    }

    public function images()
    {
        return $this->hasMany(ServiceImage::class, 'service_id');
    }

    public function writer()
    {
        return $this->belongsTo(Writer::class, 'writer_id');
    }

    public function childs()
    {
        return $this->hasMany(Service::class, 'parent_id')->where('status', 1)->orderBy('order', 'asc');
    }

    public function projects()
    {
        return $this->hasMany(Project::class, 'service_id')->where('status', 1);
    }

    public function getLinkAttribute()
    {
        return LaravelLocalization::LocalizeUrl('service/' . $this->{'link_' . $this->setCurrentLang()});
    }

    public function getNameAttribute()
    {
        return $this->{'name_' . $this->setCurrentLang()};
    }
    public function getTitleAttribute()
    {
        return $this->{'title_' . $this->setCurrentLang()};
    }

    public function getTextAttribute()
    {
        return $this->{'text_' . $this->setCurrentLang()};
    }

    public function getText1Attribute()
    {
        return $this->{'text1_' . $this->setCurrentLang()};
    }

    public function getImgAttribute()
    {
        if ($this->attributes['img']) {
            return url('uploads/services/source/' . $this->attributes['img']);
        }
        return url('resources/assets/back/images/noimage.jpg');
    }

    public function getIconAttribute()
    {
        if ($this->attributes['icon']) {
            return url('uploads/services/source/' . $this->attributes['icon']);
        }
        return url('resources/assets/back/images/noimage.jpg');
    }

    public function getBannerAttribute()
    {
        if ($this->attributes['banner']) {
            return url('uploads/services/source/' . $this->attributes['banner']);
        }
        return url('resources/assets/back/images/noimage.jpg');
    }

    public function getFileAttribute()
    {
        if ($this->attributes['file']) {
            return url('uploads/services/pdfs/' . $this->attributes['file']);
        }
        return url('resources/assets/back/images/noimage.jpg');
    }
}
