@extends('layouts.admin')
<title>{{trans('home.edit_menu_item')}}</title>
@section('content')

<div class="container-fluid">

    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.menu_items')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/menu-items')}}">{{trans('home.menu_items')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.edit_menu_item')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

    <!-- Row-->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{trans('home.edit_menu_item')}}</h4>
                </div>

                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">

                            <form method="POST" action="{{ url('admin/menu-items/' . $menuItem->id) }}" enctype="multipart/form-data" data-toggle="validator">
                                @method('PATCH')
                                @csrf
                                <div class="row">

                                    <div class="col-md-3 mb-3">
                                        <label class="">{{trans('home.name_en')}}</label>
                                        <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" value="{{$menuItem->name_en}}" required>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label class="">{{trans('home.name_ar')}}</label>
                                        <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{$menuItem->name_ar}}" required>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label for="parent" class="form-label font-size-13 text-muted">{{trans('home.parent')}}</label>
                                        <select class="form-control parent" data-trigger name="parent">
                                            <option value="0">{{trans('home.no_parent')}}</option>
                                            @foreach($menuParents as $menuParent)
                                            <option value="{{$menuParent->id}}" {{($menuParent->id == $menuItem->parent_id)?'selected':''}}>@if(app()->getLocale() == 'en') {{ $menuParent->name_en}} @else {{ $menuParent->name_ar}} @endif</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <fieldset class="form-group">
                                            <label for="order">{{trans('home.order')}}</label>
                                            <input type="number" min="1" class="form-control" placeholder="{{trans('home.order')}}" name="order" value="{{$menuItem->order}}" required>
                                        </fieldset>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label for="menu" class="form-label font-size-13 text-muted">{{trans('home.menu')}}</label>
                                        <select class="form-control menu" data-trigger name="menu_id">
                                            @foreach($menus as $menu)
                                            <option value="{{$menu->id}}" {{($menu->id == $menuItem->menu_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar}}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label for="menu_type" class="form-label font-size-13 text-muted">{{trans('home.menu_type')}}</label>
                                        <select class="form-control menu_type" data-trigger name="menu_type" required>
                                            <option></option>
                                            <option value="main-item" {{($menuItem->type == 'main-item')?'selected':''}}>{{trans('home.main-item')}}</option>
                                            <option value="home" {{($menuItem->type == 'home')?'selected':''}}>{{trans('home.home')}}</option>
                                            <option value="about-us" {{($menuItem->type == 'about-us')?'selected':''}}>{{trans('home.about-us')}}</option>
                                            <option value="contact-us" {{($menuItem->type == 'contact-us')?'selected':''}}>{{trans('home.contact-us')}}</option>
                                            <!--<option value="board-of-members" {{($menuItem->type == 'board-of-members')?'selected':''}}>{{trans('home.boardofmembers')}}</option>-->
                                            <option value="category" {{($menuItem->type == 'category')?'selected':''}}>{{trans('home.category')}}</option>
                                            <option value="categories" {{($menuItem->type == 'categories')?'selected':''}}>{{trans('home.categories')}}</option>
                                            <option value="projects" {{($menuItem->type == 'projects')?'selected':''}}>{{trans('home.projects')}}</option>
                                            <option value="project" {{($menuItem->type == 'project')?'selected':''}}>{{trans('home.project')}}</option>
                                            <option value="services" {{($menuItem->type == 'services')?'selected':''}}>{{trans('home.services')}}</option>
                                            <option value="service" {{($menuItem->type == 'service')?'selected':''}}>{{trans('home.service')}}</option>
                                            <option value="galleryImages" {{($menuItem->type == 'galleryImages')?'selected':''}}>{{trans('home.galleryImages')}}</option>
                                            <option value="galleryVideos" {{($menuItem->type == 'galleryVideos')?'selected':''}}>{{trans('home.galleryVideos')}}</option>
                                            <option value="brand" {{($menuItem->type == 'brand')?'selected':''}}>{{trans('home.brand')}}</option>
                                            <option value="brands" {{($menuItem->type == 'brands')?'selected':''}}>{{trans('home.brands')}}</option>
                                            <option value="pages" {{($menuItem->type == 'pages')?'selected':''}}>{{trans('home.pages')}}</option>
                                            <option value="blogs" {{($menuItem->type == 'blogs')?'selected':''}}>{{trans('home.blogs')}}</option>
                                            <option value="blog-category" {{($menuItem->type == 'blog-category')?'selected':''}}>{{trans('home.blog-category')}}</option>
                                            <option value="blog-item" {{($menuItem->type == 'blog-item')?'selected':''}}>{{trans('home.blog-item')}}</option>
                                            <option value="careers" {{($menuItem->type == 'careers')?'selected':''}}>{{trans('home.careers')}}</option>
                                            <option value="training" {{($menuItem->type == 'training')?'selected':''}}>{{trans('home.trainings')}}</option>
                                            <option value="link" {{($menuItem->type == 'link')?'selected':''}}>{{trans('home.link')}}</option>
                                        </select>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <div class="type_values">

                                            @if($menuItem->type == 'product' || $menuItem->type == 'brand' || $menuItem->type == 'category')
                                            <fieldset class="form-group">
                                                <label for="blog_categories" class="form-label font-size-13 text-muted">{{trans("home.$menuItem->type")}}</label>
                                                <select class="form-control type_value" data-trigger data-trigger s name="type_value" id="type_value">
                                                    @foreach($values as $value)
                                                    <option value="{{$value -> id}}" {{($menuItem->type_value == $value->id)?'selected':''}}>@if(app()->getLocale() == 'en') {{$value -> name_en}} @else {{$value -> name_ar}}@endif</option>
                                                    @endforeach
                                                </select>
                                            </fieldset>
                                            @elseif($menuItem->type == 'blog-item' ||$menuItem->type == 'pages' ||$menuItem->type == 'service' ||$menuItem->type == 'project')
                                            <fieldset class="form-group">
                                                <label for="blog_categories" class="form-label font-size-13 text-muted">{{trans("home.$menuItem->type")}}</label>
                                                <select class="form-control type_value" data-trigger data-trigger s name="type_value" id="type_value">
                                                    @foreach($values as $value)
                                                    <option value="{{$value -> id}}" {{($menuItem->type_value == $value->id)?'selected':''}}>@if(app()->getLocale() == 'en') {{$value -> name_en}} @else {{$value -> name_ar}}@endif</option>
                                                    @endforeach
                                                </select>
                                            </fieldset>
                                            @elseif($menuItem->type == 'blog-category')
                                            <fieldset class="form-group">
                                                <label for="blog_categories" class="form-label font-size-13 text-muted">{{trans("home.$menuItem->type")}}</label>
                                                <select class="form-control type_value" data-trigger data-trigger s name="type_value" id="type_value">
                                                    @foreach($values as $value)
                                                    <option value="{{$value -> id}}" {{($menuItem->type_value == $value->id)?'selected':''}}>@if(app()->getLocale() == 'en') {{$value -> title_en}} @else {{$value -> title_ar}}@endif</option>
                                                    @endforeach
                                                </select>
                                            </fieldset>
                                            @elseif($menuItem->type == 'home' || $menuItem->type == 'about-us' || $menuItem->type == 'contact-us' || $menuItem->type =='board-of-members' || $menuItem->type =='galleryImages')
                                            <fieldset class="form-group">
                                            </fieldset>
                                            @elseif($menuItem->type == 'link')
                                            <fieldset class="form-group">
                                                <label for="regions">{{trans('home.link')}}</label>
                                                <input type="text" class="form-control type_value" placeholder="{{trans('home.link')}}" value="{{$menuItem->link_en}}" name="type_value">
                                            </fieldset>
                                            @endif

                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="menu">{{trans('home.meta_keywords')}}</label>
                                        <textarea class="form-control " name="meta_keywords" placeholder="{{trans('home.meta_keywords')}}">{{$menuItem->meta_keywords}}</textarea>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="menu">{{trans('home.meta_description')}}</label>
                                        <textarea class="form-control " name="meta_description" placeholder="{{trans('home.meta_description')}}">{{$menuItem->meta_description}}</textarea>
                                    </div>
                                </div>
                                <div class="form-group">

                                    <div class="form-check d-flex">
                                        <input type="checkbox" value="1" name="status" id="switch" switch="success" {{($menuItem->status == 1)? 'checked':''}} />
                                        <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                        <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                    <a href="{{url('/admin/menu-items')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                                </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    </div>

    @endsection
    @section('script')
    <script>
        $('.menu_type').on('change', function() {
            var type = $('.menu_type option:selected').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{route('menuTypeValue')}}",
                method: 'POST',
                data: {
                    type: type
                },
                success: function(html) {
                    $('.type_values').html(html.html);
                }
            });
        });
    </script>
    @endsection