<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.seo_assistant')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.seo_assistant')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.seo_assistant')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.seo_assistant')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/seo-assistant/'.$seo->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">
                                
                                <div class="form-group col-md-6">
                                    <label for="home_meta_title"> <?php echo e(trans('home.home_meta_title')); ?></label>
                                    <textarea class="form-control" name="home_meta_title" placeholder="<?php echo e(trans('home.home_meta_title')); ?>"><?php echo e($seo->home_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="home_meta_desc"> <?php echo e(trans('home.home_meta_desc')); ?></label>
                                    <textarea class="form-control" name="home_meta_desc" placeholder="<?php echo e(trans('home.home_meta_desc')); ?>"><?php echo e($seo->home_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="home_meta_robots" value="1" <?php echo e(($seo->home_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.home_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                                
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="about_meta_title"> <?php echo e(trans('home.about_meta_title')); ?></label>
                                    <textarea class="form-control" name="about_meta_title" placeholder="<?php echo e(trans('home.about_meta_title')); ?>"><?php echo e($seo->about_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="about_meta_desc"> <?php echo e(trans('home.about_meta_desc')); ?></label>
                                    <textarea class="form-control" name="about_meta_desc" placeholder="<?php echo e(trans('home.about_meta_desc')); ?>"><?php echo e($seo->about_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="about_meta_robots" value="1" <?php echo e(($seo->about_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.about_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                                
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="contact_meta_title"> <?php echo e(trans('home.contact_meta_title')); ?></label>
                                    <textarea class="form-control" name="contact_meta_title" placeholder="<?php echo e(trans('home.contact_meta_title')); ?>"><?php echo e($seo->contact_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="contact_meta_desc"> <?php echo e(trans('home.contact_meta_desc')); ?></label>
                                    <textarea class="form-control" name="contact_meta_desc" placeholder="<?php echo e(trans('home.contact_meta_desc')); ?>"><?php echo e($seo->contact_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="contact_meta_robots" value="1" <?php echo e(($seo->contact_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.contact_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                                
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="gallery_images_meta_title"> <?php echo e(trans('home.gallery_images_meta_title')); ?></label>
                                    <textarea class="form-control" name="gallery_images_meta_title" placeholder="<?php echo e(trans('home.gallery_images_meta_title')); ?>"><?php echo e($seo->gallery_images_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="gallery_images_meta_desc"> <?php echo e(trans('home.gallery_images_meta_desc')); ?></label>
                                    <textarea class="form-control" name="gallery_images_meta_desc" placeholder="<?php echo e(trans('home.gallery_images_meta_desc')); ?>"><?php echo e($seo->gallery_images_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="gallery_images_meta_robots" value="1" <?php echo e(($seo->gallery_images_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.gallery_images_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                                
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="gallery_videos_meta_title"> <?php echo e(trans('home.gallery_videos_meta_title')); ?></label>
                                    <textarea class="form-control" name="gallery_videos_meta_title" placeholder="<?php echo e(trans('home.gallery_videos_meta_title')); ?>"><?php echo e($seo->gallery_videos_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="gallery_videos_meta_desc"> <?php echo e(trans('home.gallery_videos_meta_desc')); ?></label>
                                    <textarea class="form-control" name="gallery_videos_meta_desc" placeholder="<?php echo e(trans('home.gallery_videos_meta_desc')); ?>"><?php echo e($seo->gallery_videos_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="gallery_videos_meta_robots" value="1" <?php echo e(($seo->gallery_videos_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.gallery_videos_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>

                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="services_meta_title"> <?php echo e(trans('home.services_meta_title')); ?></label>
                                    <textarea class="form-control" name="services_meta_title" placeholder="<?php echo e(trans('home.services_meta_title')); ?>"><?php echo e($seo->services_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="services_meta_desc"> <?php echo e(trans('home.services_meta_desc')); ?></label>
                                    <textarea class="form-control" name="services_meta_desc" placeholder="<?php echo e(trans('home.services_meta_desc')); ?>"><?php echo e($seo->services_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="services_meta_robots" value="1" <?php echo e(($seo->services_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.services_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>

                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="projects_meta_title"> <?php echo e(trans('home.projects_meta_title')); ?></label>
                                    <textarea class="form-control" name="projects_meta_title" placeholder="<?php echo e(trans('home.projects_meta_title')); ?>"><?php echo e($seo->projects_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="projects_meta_desc"> <?php echo e(trans('home.projects_meta_desc')); ?></label>
                                    <textarea class="form-control" name="projects_meta_desc" placeholder="<?php echo e(trans('home.services_meta_desc')); ?>"><?php echo e($seo->projects_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="projects_meta_robots" value="1" <?php echo e(($seo->projects_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.projects_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                                
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="blogs_meta_title"> <?php echo e(trans('home.blogs_meta_title')); ?></label>
                                    <textarea class="form-control" name="blogs_meta_title" placeholder="<?php echo e(trans('home.blogs_meta_title')); ?>"><?php echo e($seo->blogs_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="blogs_meta_desc"> <?php echo e(trans('home.blogs_meta_desc')); ?></label>
                                    <textarea class="form-control" name="blogs_meta_desc" placeholder="<?php echo e(trans('home.blogs_meta_desc')); ?>"><?php echo e($seo->blogs_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="blogs_meta_robots" value="1" <?php echo e(($seo->blogs_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.blogs_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                        
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="book_now_meta_title"> <?php echo e(trans('homecareer_meta_title')); ?></label>
                                    <textarea class="form-control" name="book_now_meta_title" placeholder="<?php echo e(trans('homecareer_meta_title')); ?>"><?php echo e($seo->book_now_meta_title); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="book_now_meta_desc"> <?php echo e(trans('homecareer_meta_desc')); ?></label>
                                    <textarea class="form-control" name="book_now_meta_desc" placeholder="<?php echo e(trans('homecareer_meta_desc')); ?>"><?php echo e($seo->book_now_meta_desc); ?></textarea>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="book_now_meta_robots" value="1" <?php echo e(($seo->book_now_meta_robots == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('homecareer_meta_robots')); ?> (index)</span>
                                    </label>
                                </div>
                                
                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/nomw/resources/views/admin/seo/seo.blade.php ENDPATH**/ ?>