<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subheaders', function (Blueprint $table) {
            $table->id();
            $table->string('title_en')->nullable();
            $table->string('title_ar')->nullable();
            $table->string('text_en', 1000)->nullable();
            $table->string('text_ar', 1000)->nullable();
            $table->integer('order')->index();
            $table->enum('type', [
                'about',
                'services',
                'gallery',
                'contact',
                'blogs',
                'reviews',
                'whyus',
                'teams',
                'projects',
                'awards',
                'brands',
            ])->nullable();
            $table->string('image', 100)->nullable();
            $table->integer('number')->nullable();
            $table->tinyInteger('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subheaders');
    }
};
