@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection
@section('BreadCrumb', $category->{'name_'.$lang})
@section('BreadCrumb2',$category->{'name_'.$lang})
@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    @include('website.web-partials.BreadCrumb')
    <!-- <================================================================= BreadCrumb =======================================================> -->

    <div class="page-content">

        <!-- Start Shop Section -->
        <section class="shop-section pt-100 pb-70">
            <div class="container">
                <div class="section-title">
                    <span>{{__('home.products')}} </span>
                    <h3>{{$category->{'name_'.$lang} }}</h3>
                </div>

                <div class="tab shop-list-tab">
                    <ul class="tabs">
                       
                            <li>
                                <a href="#">
                                    <span>{{$category->{'desc_'.$lang} }}</span>
                                </a>
                            </li>
                      

                    </ul>
                    <div class="tab_content">
                      
                            <div class="tabs_item">
                                <div class="row align-items-center">
                                    @foreach ($category->projects as $project)
                                        <div class="col-lg-4 col-md-6 col-sm-6">
                                            <div class="shop-item">
                                                <a href="{{ LaravelLocalization::localizeUrl('project/' . $project->{'link_' . $lang}) }}">
                                                    <div class="shop-image">
                                                        
                                                       <img src="{{ Helper::uploadedImagesPath('projects', $project->image) }}" alt="image">
                                                       
                                                    </div>
                                                    </a>
                                                <div class="shop-content">
                                                        <h3><a href="{{ LaravelLocalization::localizeUrl('project/' . $project->{'link_' . $lang}) }}">{{$project->{'name_'.$lang} }}</a></h3>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                       
                    </div>
                </div>
            </div>
        </section>
        <!-- End Shop Section -->
    </div>
@endsection
