@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection
@section('BreadCrumb', $service->{'name_' . $lang})
@section('BreadCrumb2', __('home.services'))
@section('seg', $service->{'link_' . $lang})
@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    @include('website.web-partials.BreadCrumb')
    <!-- <================================================================= BreadCrumb =======================================================> -->

   <section class="blog_details_area service-details">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="service-details-thumb">
                                <img src="{{ Helper::uploadedImagesPath('services', $service->img) }}" alt="thumb">
                            </div>
                            <div class="blog-details-content">
                                <h4 class="services-details-title">{{ $service->{'name_' . $lang} }}</h4>
                                <p class="blog-details-desc">{!! $service->{'text_'.$lang} !!}</p>
                            </div>

                            @if (count($service->images()))
                                <div class="row">
                                    <div class="gallery-title">
                                        <h3>{{ __('home.gallery') }}</h3>
                                    </div>
                                    @foreach ($service->images() as $key => $image)
                                        <div class="col-lg-6">
                                            <div class="gallery-thumb">
                                                <img src="{{ Helper::uploadedImagesPath('services', $image->image) }}"
                                                    alt="thumb2">
                                                <a class="venobox vbox-item" data-gall="gallery-thumb"
                                                    href="{{ Helper::uploadedImagesPath('services', $image->image) }}">
                                                    <span class="plus-icon"><i class="fa-solid fa-plus"></i></span>
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="row">
                        <div class="col-lg-12 contact-area">
                            <div class="widget-sidber">
                                <div class="widget-sidber-content">
                                    <h4>{{ __('home.categories') }}</h4>
                                </div>
                                <div class="widget-category">
                                    <ul>
                                        @foreach ($services as $rel_service)
                                            <li><a
                                                    href="{{ LaravelLocalization::localizeUrl('service/' . $rel_service->{'link_' . $lang}) }}"><img
                                                        src="{{ asset('resources/assets/front/images/inner-img/category-icon.png') }}"
                                                        alt="icon">{{ $rel_service->{'name_' . $lang} }}<i
                                                        class="bi bi-arrow-right"></i></a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                         @if($service->file)

                            <div class="widget-sidber">
                                <div class="widget-sidber-content">
                                    <h4>{{__('home.downloads')}}</h4>
                                </div>
                                <div class="widget-sidber-download-button">

                                    <a class="active" href="{{url('uploads/services/pdfs')}}/{{$service->file}}" onclick="document.getElementById('fileUpload').click();" target="_blank"><i class="bi bi-file-earmark-pdf"></i>Download <span><i
                                                class="bi bi-download"></i></span></a>
                                </div>
                            </div>
                            @endif

                            <div class="widget-sidbar">
                                <div class="section_title text-center">
                                    <h1>{{__('home.contact-us')}}</h1>
                                </div>
                                @include('website.web-partials.contactform')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
