<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_blog_item')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.blogItems')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/blog-items')); ?>"><?php echo e(trans('home.blogItems')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_blog_item')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.edit_blog_category')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <!-- End Page Header -->
                            <?php echo Form::open(['method'=>'PATCH','url' => 'admin/blog-items/'.$blogItem->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">

                                    <div class="col-md-4 mb-3">
                                        <label for="title_en"><?php echo e(trans('home.title_en')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_en')); ?>" name="title_en" value="<?php echo e($blogItem->title_en); ?>" required>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="title_ar"><?php echo e(trans('home.title_ar')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.title_ar')); ?>" name="title_ar" value="<?php echo e($blogItem->title_ar); ?>">
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="parent"><?php echo e(trans('home.blogCategory')); ?></label>
                                        <select class="form-control" data-trigger name="blogcategory_id">
                                            <?php $__currentLoopData = $blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($blogCategory->id); ?>" <?php echo e(($blogCategory->id == $blogItem->blogcategory_id)?'selected':''); ?>><?php echo e((app()->getLocale()=='en')? $blogCategory->title_en:$blogCategory->title_ar); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="type"><?php echo e(trans('home.writers')); ?></label>
                                        <select class="form-control select2 type" name="writer_id">
                                            <?php $__currentLoopData = $writers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $writer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($writer->id); ?>" <?php if($writer->id == $blogItem->writer_id): ?>selected <?php endif; ?>><?php echo e($writer->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="code"><?php echo e(trans('home.date')); ?></label>
                                        <div class="input-group">
                                            <input type='text' class="form-control" name="date" placeholder="<?php echo e(trans('home.date')); ?>" id="datepicker" value="<?php echo e($blogItem->date); ?>"  required/>
                                            <div class="input-group-append">
                                                <span class="input-group-text">
                                                    <i class="fas fa-calendar"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-3 mt-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>

                                    <div class="col-md-3 mb-3 mt-3">
                                        <label ><?php echo e(trans('home.alt_img')); ?></label>
                                        <input class="form-control" name="alt_img" type="text" value="<?php echo e($blogItem->alt_img); ?>" placeholder="<?php echo e(trans('home.alt_img')); ?>" />
                                    </div>  


                                    <?php if($blogItem->image): ?>
                                        <div class="form-group  col-md-2 m-2 mt-3">
                                            <img src="<?php echo e(url('\uploads\blogitems\source')); ?>\<?php echo e($blogItem->image); ?>" width="200" height="150">
                                        </div>
                                    <?php else: ?>
                                        <div class="form-group  col-md-3 mt-3">
                                            <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                        </div>
                                    <?php endif; ?>

                                    <div class="form-group col-md-6 ">
                                        <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ><?php echo $blogItem->text_en; ?></textarea>
                                    </div>

                                    <div class="form-group col-md-6 ">
                                        <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ><?php echo $blogItem->text_ar; ?></textarea>
                                    </div>
                                    <div class="form-group col-md-12 mt-3">
                                        <hr>
                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.faq')); ?></h4>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="field_wrapper">
                                            <div class="row">
                                                <?php if(count($questions) > 0): ?>
                                                    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-md-5 mb-3">
                                                            <label for="question"><?php echo e(trans('home.writer')); ?></label>
                                                            <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.writer')); ?>" readonly value="<?php echo e($question->question); ?>">
                                                        </div>

                                                        <div class="col-md-5 mb-3">
                                                            <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                            <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" readonly><?php echo e($question->answer); ?></textarea>
                                                        </div>

                                                        <div class="form-group col-md-2">
                                                            <button type="button" style="margin-top: 28px;" class="btn" data-bs-toggle="modal" data-bs-target="#iconForm_<?php echo e($key); ?>"><i class="fas fa-edit"></i></button>
                                                            <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="<?php echo e($question->id); ?>" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div class="col-md-6 mb-3">
                                                        <label for="question"><?php echo e(trans('home.writer')); ?></label>
                                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.writer')); ?>" name="question[]">
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                                        <textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <a href="javascript:void(0);" class="add_button btn m-2" title="Add field"><i class="fas fa-plus-square"></i></a>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.seo_block')); ?></h4>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.en')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en" value="<?php echo e($blogItem->link_en); ?>">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($blogItem->meta_title_en); ?></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($blogItem->meta_desc_en); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.ar')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar" value="<?php echo e($blogItem->link_ar); ?>">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($blogItem->meta_title_ar); ?></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($blogItem->meta_desc_ar); ?></textarea>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($blogItem->status == 1)? 'checked':''); ?>  />
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="home" id="switch1" switch="success" <?php echo e(($blogItem->home == 1)? 'checked':''); ?>  />
                                            <label for="switch1" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch1"> <?php echo e(trans('home.home')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="meta_robots" id="switch2" switch="success" <?php echo e(($blogItem->meta_robots == 1)? 'checked':''); ?>  />
                                            <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.meta_robots')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/blog-items')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>

                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade text-left" id="iconForm_<?php echo e($key); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_faq')); ?></h3>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('updateFaq')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <label for="question"><?php echo e(trans('home.question')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question" value="<?php echo e($question->question); ?>">
                                </div>

                                <div class="form-group col-md-12">
                                    <label for="answer"><?php echo e(trans('home.answer')); ?></label>
                                    <textarea type="text"  class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer" ><?php echo e($question->answer); ?></textarea>
                                </div>

                                <input type="hidden" name="faq_id" value="<?php echo e($question->id); ?>"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?> </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script>

        $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML ='<div class="row"><div class="form-group col-md-6"><label for="question"><?php echo e(trans('home.question')); ?></label><input type="text"  class="form-control" placeholder="<?php echo e(trans('home.question')); ?>" name="question[]"></div>';
            fieldHTML +='<div class="form-group col-md-5"><label for="answer"><?php echo e(trans('home.answer')); ?></label><textarea class="form-control" placeholder="<?php echo e(trans('home.answer')); ?>" name="answer[]"></textarea></div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });

        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo e(route('removeFaq')); ?>",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\drahmednagib\resources\views/admin/blogItems/editBlogItem.blade.php ENDPATH**/ ?>