<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_address')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.addresses')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/addresses')); ?>"><?php echo e(trans('home.addresses')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_address')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/addresses/'.$address->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_address')); ?></h6>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.address_en')); ?></label>
                                <input class="form-control" name="address_en" type="text" placeholder="<?php echo e(trans('home.address_en')); ?>"  value="<?php echo e($address->address_en); ?>" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.address_ar')); ?></label>
                                <input class="form-control" name="address_ar" type="text" placeholder="<?php echo e(trans('home.address_ar')); ?>" value="<?php echo e($address->address_ar); ?>" >
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo e(trans('home.tel')); ?></label>
                                <input class="form-control" name="tel" type="text" placeholder="<?php echo e(trans('home.phone')); ?>" value="<?php echo e($address->tel); ?>">
                            </div>
                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.email')); ?></label>
                                <input class="form-control" name="email" type="email" placeholder="<?php echo e(trans('home.email')); ?>" value="<?php echo e($address->email); ?>" >
                            </div>

                            <div class="col-md-12">
                                <label><?php echo e(trans('home.map_url')); ?></label>
                                <textarea class="form-control" name="map_url" type="text" placeholder="<?php echo e(trans('home.map_url')); ?>"><?php echo e($address->map_url); ?></textarea>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent"><?php echo e(trans('home.type')); ?></label>
                                <select class="form-control select2" name="type">
                                    <option value="Office" <?php echo e($address->type=='Office'?'selected':''); ?> >Office</option>
                                    <option value="Studio" <?php echo e($address->type=='Studio'?'selected':''); ?> >Studio</option>
                                    <option value="Shop" <?php echo e($address->type=='Shop'?'selected':''); ?> >Shop</option>
                                </select>
                            </div>

                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1" <?php echo e(($address->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/addresses')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    <?php echo Form::close(); ?>


</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/calibre/resources/views/admin/addresses/editAddress.blade.php ENDPATH**/ ?>