<title><?php echo e(trans('home.edit_company')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.clients')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/brands')); ?>"><?php echo e(trans('home.companies')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_company')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <!-- End Page Header -->
                            <?php echo Form::open(['method'=>'PATCH','url' => 'admin/brands/'.$brand->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">

                                   

                                    <div class="col-md-8 mb-3 mt-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_logo')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="logo">
                                    </div>



                                    <?php if($brand->logo): ?>
                                        <div class="form-group  col-md-2 m-2 mt-3">
                                            <img src="<?php echo e(url('\uploads\brands\source')); ?>\<?php echo e($brand->logo); ?>" width="200" height="150">
                                        </div>
                                    <?php else: ?>
                                        <div class="form-group  col-md-3 mt-3">
                                            <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-md-1 m-2 mt-3">
                                    <label for="order"><?php echo e(trans('home.order')); ?></label>
                                    <input type="number" min="0" class="form-control"
                                        placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($brand->order); ?>">
                                    </div>
                                    

                                </div>
                                <div class="row">
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($brand->status == 1)? 'checked':''); ?>  />
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-4">
                                        
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="meta_robots" id="switch2" switch="success" <?php echo e(($brand->meta_robots == 1)? 'checked':''); ?>  />
                                            <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.meta_robots')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/brands')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/mobility/resources/views/admin/brands/editBrand.blade.php ENDPATH**/ ?>