
<title><?php echo e(trans('home.pages')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.pages')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.pages')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/pages/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.pages')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.title')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.text')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.link')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($page->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($page->id); ?>" /> </td>
                                        <td><a href="<?php echo e(route('pages.edit', $page->id)); ?>"><?php echo e($page->id); ?></a></td>
                                        <td><a href="<?php echo e(route('pages.edit', $page->id)); ?>"><?php echo e((app()->getLocale() == 'en')?$page->title_en:$page->title_ar); ?></a></td>
                                        <td><a href="<?php echo e(route('pages.edit', $page->id)); ?>"><?php echo ($lang == 'en')?substr($page->text_en,0,150).' ...':substr($page->text_ar,0,150).' ...'; ?></a></td>
                                        <td><a href="<?php echo e(route('pages.edit', $page->id)); ?>"><?php echo e($page->link_en); ?></a></td>
                                        <td><a href="<?php echo e(route('pages.edit', $page->id)); ?>"><?php if($page->status == 1): ?> <?php echo e(trans('home.yes')); ?> <?php else: ?>  <?php echo e(trans('home.no')); ?> <?php endif; ?></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\haliem_company_profile\resources\views/admin/pages/pages.blade.php ENDPATH**/ ?>