<!-- service details area start -->
<div class="blog-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 blog-details-wrapper">
                <!-- Post Details Start -->
                <article class="single-post-item">
                    <div class="post-thumbnail">
                        <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $blog->image)); ?>" alt="Blog Image" />
                    </div>
                    <div class="post-content-wrapper">
                        <h3 class="post-title">
                            <?php echo e($blog->{'title_' . $lang}); ?>

                        </h3>
                        <div class="post-content">
                            <p><?php echo $blog->{'text_' . $lang}; ?></p>
                        </div>
                    </div>
                </article>
                <div class="blog-post-nav">
                    <?php if($previousBlog != null): ?>
                        <div class="post-navigation">
                            <div class="post-img">
                                <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $previousBlog->image)); ?>"
                                    width="100" height="100" alt="image">
                            </div>
                            <div class="text">
                                <span><a
                                        href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $previousBlog->{'link_' . $lang})); ?>"><?php echo e(trans('home.previousBlog')); ?></a></span>
                                <h3 class="post-title">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $previousBlog->{'link_' . $lang})); ?>"
                                        rel="prev">
                                        <?php echo e($previousBlog->{'title_' . $lang}); ?>

                                    </a>
                                </h3>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($nextBlog != null): ?>
                        <div class="post-navigation">
                            <div class="post-img">
                                <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $nextBlog->image)); ?>"
                                    width="100" height="100" alt="image">
                            </div>
                            <div class="text">
                                <span><a
                                        href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $nextBlog->{'link_' . $lang})); ?>"><?php echo e(trans('home.nextBlog')); ?></a></span>
                                <h3 class="post-title">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $nextBlog->{'link_' . $lang})); ?>"
                                        rel="next">
                                        <?php echo e($nextBlog->{'title_' . $lang}); ?>

                                    </a>
                                </h3>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <!-- Post Details End -->
            </div>
            <!-- Blog Sidebar Start -->
            <div class="col-lg-4 order-1 order-lg-2 position-relative">
                <div class="sidebar">
                    <div class="widget widget_latest_post">
                        <div class="widget-title-box">
                            <h4 class="wp-block-heading"><?php echo e(trans('home.related_blogs')); ?></h4>
                        </div>
                        <ul>
                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogRelated): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="latest-post-thumb">
                                        <a
                                            href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $blogRelated->{'link_' . $lang})); ?>">
                                            <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $blogRelated->image)); ?>"
                                                alt="blog->image" />
                                        </a>
                                    </div>
                                    <div class="latest-post-desc">
                                        <h3 class="latest-post-title">
                                            <a
                                                href="<?php echo e(LaravelLocalization::LocalizeUrl('blog/' . $blogRelated->{'link_' . $lang})); ?>"><?php echo e($blogRelated->{'title_' . $lang}); ?>.</a>
                                        </h3>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="footer-contact comment-respond mt-0 me-0">
                        <form action="<?php echo e(LaravelLocalization::LocalizeUrl('save/contact-us')); ?>" method="POST"
                            class="comment-form">
                            <?php echo csrf_field(); ?>
                            <div class="row gx-2">
                                <div class="col-xl-6">
                                    <div class="contacts-name">
                                        <input name="name" type="text" placeholder="<?php echo e(trans('home.name')); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="contacts-email">
                                        <input name="phone" type="text" placeholder="<?php echo e(trans('home.phone')); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="contacts-email">
                                        <input name="email" type="text" placeholder="<?php echo e(trans('home.email')); ?>">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="contacts-message">
                                        <textarea name="message" cols="20" rows="3" placeholder="<?php echo e(trans('home.message')); ?>"></textarea>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button class="theme-btn" type="submit"><?php echo e(trans('home.send')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <br>
                    <div class="widget widget_social_profile">
                        <div class="widget-title-box">
                            <h4 class="wp-block-heading"><?php echo e(trans('home.Follow Us')); ?></h4>
                        </div>
                        <div class="social-profile">
                            <?php if($setting->facebook): ?>
                                <a class="facebook" href="<?php echo e($setting->facebook); ?>"><i
                                        class="fa-brands fa-facebook-f"></i></a>
                            <?php endif; ?>
                            <?php if($setting->twitter): ?>
                                <a class="twitter" href="<?php echo e($setting->twitter); ?>">
                                    <i class="fa-brands fa-twitter"></i></a>
                            <?php endif; ?>
                            <?php if($setting->youtube): ?>
                                <a class="youtube" href="<?php echo e($setting->youtube); ?>"><i
                                        class="fa-brands fa-youtube"></i></a>
                            <?php endif; ?>
                            <?php if($setting->instgram): ?>
                                <a class="instagram" href="<?php echo e($setting->instgram); ?>"><i
                                        class="fa-brands fa-instagram"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Blog Sidebar Start -->
        </div>
    </div>
</div>
<!-- service details area end -->
<?php /**PATH C:\OSPanel\domains\homy\resources\views/website/section-partials/blogdetails.blade.php ENDPATH**/ ?>