<!doctype html>
<html lang="en" <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1.0" />
    <meta name="keywords" content="" />
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Favicon Icon -->
    <link rel="shortcut icon" href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>" />
    <!-- Favicon Icon -->
    <!-- Load the Cairo font with variable weights from 200 to 1000 -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">
    <!-- font to improve first paint performance -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Oswald:wght@300;400;500;600;700&amp;family=Outfit:wght@300;400;500;600;700&amp;display=swap">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />

    <!--=============== css  ===============-->
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
    <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery-migrate-3.4.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('modernizr-2.6.2.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.isotope.v3.0.2.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('scrollIt.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.stellar.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('YouTubePopUp.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('vegas.slider.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('custom.js')); ?>"></script>
    <!-- Jquery Library File -->
    <?php echo $__env->yieldContent('script'); ?>
    <script>
        $(document).ready(function() {
            var sliders = [
                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        src: "<?php echo e(url('uploads/sliders/home-sliders/source/' . $slider->image)); ?>",
                        title: "<?php echo e($slider->title); ?>",
                        title1: "<?php echo e($slider->title1); ?>",
                        text: `<?php echo $slider->text; ?>`
                    }
                    <?php if(!$loop->last): ?>
                        ,
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];

            // Vegas slider initialization
            $('#kenburnsSliderContainer').vegas({
                slides: sliders,
                overlay: true,
                transition: 'fade2',
                animation: 'kenburnsUpRight',
                transitionDuration: 1000,
                delay: 10000,
                animationDuration: 20000,
                walk: function(index, slideSettings) {
                    // Update titles and text for each slide
                    $('#slider-title').text(slideSettings.title);
                    $('#slider-title1').text(slideSettings.title1);
                    $('#slider-text').html(slideSettings.text);
                }
            });
        });
    </script>

</body>

</html>
<?php /**PATH C:\OSPanel\domains\dramrsamy\resources\views/layouts/app.blade.php ENDPATH**/ ?>