<!doctype html>
<html lang="{{ LaravelLocalization::getCurrentLocale() }}"
    @if (LaravelLocalization::getCurrentLocaleDirection() == 'ltr') dir="ltr" @else dir="rtl" @endif>

<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--=============== FavIcon  ===============-->
    <link rel="icon" type="image/png" href="{{ url('uploads/settings/source/', $configration->fav_icon) }}" />
    @yield('title')
    <!-- favicons Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=El+Messiri:wght@400..700&display=swap"
        rel="stylesheet">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('animate.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('themify-icons.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('owl.theme.default.min.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('YouTubePopUp.css') }}" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('style.css') }}" />

    {{-- @if (LaravelLocalization::getCurrentLocaleDirection() == 'rtl')
        <link rel="stylesheet" href="{{ Helper::cssFilesPath('stylertl.css') }}" />
    @else
        <link rel="stylesheet" href="{{ Helper::cssFilesPath('style.css') }}" />
    @endif --}}
</head>

<body>

    <div class="content-wrapper">
        @include('layouts.partials.preloader')
        @include('layouts.partials.navigation')
        @include('layouts.partials.header')
        @yield('content')
        @include('layouts.partials.footer')
        {{-- @include('layouts.partials.social') --}}
        @include('layouts.partials.PopForm')
    </div>



    <!-- JS here -->
    <script src="{{ Helper::jsFilesPath('plugins/jquery-3.6.1.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/bootstrap.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/modernizr-2.6.2.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.waypoints.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.isotope.v3.0.2.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/owl.carousel.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/scrollIt.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.magnific-popup.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/masonry.pkgd.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/YouTubePopUp.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script src="{{ Helper::jsFilesPath('script.js') }}"></script>

    <script>
        Fancybox.bind("[data-fancybox]", {
            // Your custom options
        });
    </script>

    @yield('script')

    <!--Design By Youssef & Dev By Ahmed Essam-->

</body>

</html>
