
@php
    $blogsTitles = $titles->filter(fn($title) => $title->type === 'blogs');
@endphp

@if(count($blogs) > 0)
<!--===============Blogs==============-->
<section class="blog-home section-padding">
    <div class="container">
        <div class="row mb-5">
            <div class="col-md-4">
                <div class="sub-title border-bot-light">{{ trans('home.blogs') }}</div>
            </div>
            <div class="col-md-8">
                <div class="section-title"><span>{{$title->{'title_' .$lang} }}</span> {{$title->{'title1_' .$lang} }}</div>
            </div>
        </div>
        <div class="row">
            @foreach($blogs as $blog)
            <div class="col-md-4">
                <div class="item">
                    <div class="post-img">
                        <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}">
                            <div class="img"> <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="image"> </div>
                        </a>
                    </div>
                    <div class="cont">
                        <h4><a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}"></a></h4>
                        <div class="info"> <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}"><span>{{ trans('home.blogdetials') }}</span></a> <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}"></a> </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!--===============Blogs==============-->
@endif
