@php
    $galleryTitles = $titles->filter(fn($title) => $title->type === 'gallery');
@endphp
<!--===============CTASection==============-->
@foreach ($galleryTitles as $title)
    <!--====================Gallery==============-->
    <section class="section-padding">
        <div class="container">
            <div class="row mb-5 animate-box" data-animate-effect="fadeInUp">
                <div class="col-md-4">
                    <div class="sub-title border-bot-light">{{ trans('Our Gallery') }}</div>
                </div>
                <div class="col-md-8">
                    <div class="section-title"><span>{{$title->{'title_' .$lang} }}</span> {{$title->{'title1_' .$lang} }}</div>
                </div>
            </div>
            <div class="row">
                @foreach ($albums as $key => $gallery)
                <div class="col-md-4 gallery-item animate-box" data-animate-effect="fadeInUp">
                    <div class="item">
                        <a href="{{ url('uploads/album_items/source/' . $gallery->image) }}" data-fancybox="album1-{{ $key }}" data-caption=""class="box_cat_rooms">
                            <figure>
                                <div class="background-image" style="background-image: url('{{ url('uploads/album_items/source/' . $gallery->image) }}');"></div>
                                <div class="info">
                                    <h3>{{$gallery->{'name_' .$lang} }}</h3>
                                    <span>{!! $gallery->{'text_' .$lang} !!}</span>
                                </div>

                                <div class="album-icon">
                                    <i class="ti-fullscreen"></i>
                                </div>
                            </figure>
                        </a>
                        <div class="display-on-hover">
                            @foreach ($gallery->images as $img)
                            <a href="{{ url('uploads/album_items/source/' . $img->name) }}" data-fancybox="album1-{{ $key }}" data-caption=" "><i class="fa-solid fa-eye text-white"></i></a>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            <div class="text-center">
                <a href="{{LaravelLocalization::LocalizeUrl('')}}" class="button-dark">{{ trans('Our Gallery') }}</a>
            </div>
        </div>
    </section>
    <!--====================Gallery==============-->
@endforeach
