<?php $__env->startSection('title'); ?>
    <?php echo $metatags ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-header breadcrumb-wrap">
        <div class="container">
            <div class="breadcrumb">
                <a href="<?php echo e(LaravelLocalization::localizeUrl('/' )); ?>" rel="nofollow"><i class="fi-rs-home mr-5"></i><?php echo e(__('home.home')); ?></a>

                <span></span> <a href="<?php echo e(LaravelLocalization::localizeUrl('category/'.$product->category->{'link_'.$lang}.'/products' )); ?>"><?php echo e($product->category->{'name_'.$lang}); ?></a> <span></span><?php echo e($product->{'name_'.$lang}); ?>

            </div>
        </div>
    </div>
    <div class="container mb-30">
        <div class="row">
            <div class="col-xl-11 col-lg-12 m-auto">
                <div class="row">
                    <div class="col-xl-9">
                        <div class="product-detail accordion-detail">
                            <div class="row mb-50 mt-30">
                                <div class="col-md-6 col-sm-12 col-xs-12 mb-md-0 mb-sm-5">
                                    <div class="detail-gallery">
                                        <span class="zoom-icon"><i class="fi-rs-search"></i></span>
                                        <!-- MAIN SLIDES -->
                                        <div class="product-image-slider">
                                            <?php $__currentLoopData = $product->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <figure class="border-radius-10">
                                                    <img src="<?php echo e(Helper::uploadedImagesPath('projects', $image->image)); ?>" alt="<?php echo e($product->{'name_'.$lang}); ?>" />
                                                </figure>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                        </div>


                                        <!-- THUMBNAILS -->
                                        <div class="slider-nav-thumbnails">
                                            <?php $__currentLoopData = $product->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div>
                                                    <img src="<?php echo e(Helper::uploadedImagesPath('projects', $image->image)); ?>" alt="<?php echo e($product->{'name_'.$lang}); ?>" />
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </div>
                                    </div>
                                    <!-- End Gallery -->
                                </div>
                                <div class="col-md-6 col-sm-12 col-xs-12">
                                    <div class="detail-info pr-30 pl-30">
                                        <h2 class="title-detail"><?php echo e($product->{'name_'.$lang}); ?></h2>
                                        <div class="short-desc mb-30">
                                            <p class="font-lg"><?php echo $product->{'small_text_'.$lang}; ?></p>
                                        </div>
                                        <div class="font-xs">
                                            <ul class="mr-50 float-start">
                                                <li class="mb-5"><?php echo e(__('home.brand')); ?>: <span class="text-brand"><?php echo e($product->brand->{'name_'.$lang}); ?></span></li>
                                                <li class="mb-5">MFG:<span class="text-brand"><?php echo e('  '.$product->created_at->format('d F Y')); ?></span></li>
                                                <?php $__currentLoopData = $product->attributes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li> <?php echo e($attribute->attribute_name($attribute->attribute_id)->{'name_'.$lang}.' '); ?>: <span class="text-brand"><?php echo e($attribute->attribute_value_id); ?></span></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- Detail Info -->
                                </div>
                            </div>
                            <div class="product-info">
                                <div class="tab-style3">
                                    <ul class="nav nav-tabs text-uppercase">
                                        <li class="nav-item">
                                            <a class="nav-link active" id="Description-tab" data-bs-toggle="tab"
                                               href="javascript=void();"><?php echo e(__('home.description')); ?></a>
                                        </li>
                                    </ul>
                                    <div class="tab-content shop_info_tab entry-main-content">
                                        <div class="tab-pane fade show active" id="Description">
                                            <div class="">
                                                <p><?php echo $product->{'text_'.$lang}; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 primary-sidebar sticky-sidebar mt-30">
                        <!-- Product sidebar Widget -->
                        <div class="sidebar-widget product-sidebar mb-30 p-30 bg-grey border-radius-10">
                            <h5 class="section-title style-1 mb-30"><?php echo e(__('home.new_products')); ?></h5>
                            <?php $__currentLoopData = $new_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $new_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-post clearfix">
                                    <div class="image">
                                        <img src="<?php echo e(Helper::uploadedImagesPath('projects', $new_product->image)); ?>" alt="<?php echo e($new_product->{'name_'.$lang}); ?>" />
                                    </div>
                                    <div class="content pt-10">
                                        <h5><a href="<?php echo e(LaravelLocalization::localizeUrl('product/'.$new_product->{'link_'.$lang} )); ?>">
                                                <?php echo e($new_product->{'name_'.$lang}); ?></a></h5>
                                        <p class="price mb-0 mt-5"><?php echo e($new_product->category->{'name_'.$lang}); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/website/product-details.blade.php ENDPATH**/ ?>