<!doctype html>
<html lang="en" <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Stylesheets -->
    <link rel="shortcut icon" href="<?php echo e(Helper::uploadedImagesPath('settings' , $configration->fav_icon)); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(Helper::uploadedImagesPath('settings' , $configration->fav_icon)); ?>" type="image/x-icon">
    <!-- Responsive -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('revolution-slider.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" />
    <!--=============== css  ===============-->
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style-ar.css')); ?>">
<?php endif; ?>
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
    <div class="page-wrapper">
        <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--Scroll to top-->
    <div class="scroll-to-top scroll-to-target" data-target=".main-header"><span class="fa fa-long-arrow-up"></span>
    </div>
    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('revolution.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.fancybox.pack.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.fancybox-media.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('script.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {
            Thumbs: {
                autoStart: true,
            },
        });
    </script>
    <!-- Jquery Library File -->
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\surface\resources\views/layouts/app.blade.php ENDPATH**/ ?>