<!doctype html>
<html class="no-js" lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="exdesigners">
    <meta name="description" content="Techbe-IT Solution & Technology Service Template">
    <!-- ======== Page title ============ -->
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>">
    <!--==============================
         Google Fonts
         ============================== -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&amp;display=swap"
        rel="stylesheet">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fancybox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fontawesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('main.css')); ?>" />

    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>" />
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <?php endif; ?>
</head>

<body class="bg-white">
    
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <main class="main position-relative" id="mains">
            <?php echo $__env->yieldContent('content'); ?>
    </main>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    



    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('fancybox.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('tilt.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>

    <?php echo $__env->yieldContent('script'); ?>

    <!--Design By Seif & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH C:\OSPanel\domains\africatrade\resources\views/layouts/app.blade.php ENDPATH**/ ?>